/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.Attribute;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeModifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierOperation;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ServerEntityPropertiesPacket
implements Packet {
    private int entityId;
    @NonNull
    private List<Attribute> attributes;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.attributes = new ArrayList<Attribute>();
        int length = in.readVarInt();
        for (int index = 0; index < length; ++index) {
            String key = in.readString();
            double value = in.readDouble();
            ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
            int len = in.readVarInt();
            for (int ind = 0; ind < len; ++ind) {
                modifiers.add(new AttributeModifier(in.readUUID(), in.readDouble(), MagicValues.key(ModifierOperation.class, in.readByte())));
            }
            this.attributes.add(new Attribute(MagicValues.key(AttributeType.class, Identifier.formalize(key)), value, modifiers));
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            out.writeString(MagicValues.value(String.class, (Object)attribute.getType()));
            out.writeDouble(attribute.getValue());
            out.writeVarInt(attribute.getModifiers().size());
            for (AttributeModifier modifier : attribute.getModifiers()) {
                out.writeUUID(modifier.getUuid());
                out.writeDouble(modifier.getAmount());
                out.writeByte(MagicValues.value(Integer.class, (Object)modifier.getOperation()).intValue());
            }
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityPropertiesPacket)) {
            return false;
        }
        ServerEntityPropertiesPacket other = (ServerEntityPropertiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityPropertiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "ServerEntityPropertiesPacket(entityId=" + this.getEntityId() + ", attributes=" + this.getAttributes() + ")";
    }

    public ServerEntityPropertiesPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityPropertiesPacket(entityId, this.attributes);
    }

    public ServerEntityPropertiesPacket withAttributes(@NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return this.attributes == attributes ? this : new ServerEntityPropertiesPacket(this.entityId, attributes);
    }

    private ServerEntityPropertiesPacket() {
    }

    public ServerEntityPropertiesPacket(int entityId, @NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.entityId = entityId;
        this.attributes = attributes;
    }
}

