/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerEntityPositionPacket
implements Packet {
    private int entityId;
    private double moveX;
    private double moveY;
    private double moveZ;
    private boolean onGround;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.moveX = (double)in.readShort() / 4096.0;
        this.moveY = (double)in.readShort() / 4096.0;
        this.moveZ = (double)in.readShort() / 4096.0;
        this.onGround = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeShort((int)(this.moveX * 4096.0));
        out.writeShort((int)(this.moveY * 4096.0));
        out.writeShort((int)(this.moveZ * 4096.0));
        out.writeBoolean(this.onGround);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getMoveX() {
        return this.moveX;
    }

    public double getMoveY() {
        return this.moveY;
    }

    public double getMoveZ() {
        return this.moveZ;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityPositionPacket)) {
            return false;
        }
        ServerEntityPositionPacket other = (ServerEntityPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getMoveX(), other.getMoveX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMoveY(), other.getMoveY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMoveZ(), other.getMoveZ()) != 0) {
            return false;
        }
        return this.isOnGround() == other.isOnGround();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $moveX = Double.doubleToLongBits(this.getMoveX());
        result = result * 59 + (int)($moveX >>> 32 ^ $moveX);
        long $moveY = Double.doubleToLongBits(this.getMoveY());
        result = result * 59 + (int)($moveY >>> 32 ^ $moveY);
        long $moveZ = Double.doubleToLongBits(this.getMoveZ());
        result = result * 59 + (int)($moveZ >>> 32 ^ $moveZ);
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ServerEntityPositionPacket(entityId=" + this.getEntityId() + ", moveX=" + this.getMoveX() + ", moveY=" + this.getMoveY() + ", moveZ=" + this.getMoveZ() + ", onGround=" + this.isOnGround() + ")";
    }

    public ServerEntityPositionPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityPositionPacket(entityId, this.moveX, this.moveY, this.moveZ, this.onGround);
    }

    public ServerEntityPositionPacket withMoveX(double moveX) {
        return this.moveX == moveX ? this : new ServerEntityPositionPacket(this.entityId, moveX, this.moveY, this.moveZ, this.onGround);
    }

    public ServerEntityPositionPacket withMoveY(double moveY) {
        return this.moveY == moveY ? this : new ServerEntityPositionPacket(this.entityId, this.moveX, moveY, this.moveZ, this.onGround);
    }

    public ServerEntityPositionPacket withMoveZ(double moveZ) {
        return this.moveZ == moveZ ? this : new ServerEntityPositionPacket(this.entityId, this.moveX, this.moveY, moveZ, this.onGround);
    }

    public ServerEntityPositionPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerEntityPositionPacket(this.entityId, this.moveX, this.moveY, this.moveZ, onGround);
    }

    private ServerEntityPositionPacket() {
    }

    public ServerEntityPositionPacket(int entityId, double moveX, double moveY, double moveZ, boolean onGround) {
        this.entityId = entityId;
        this.moveX = moveX;
        this.moveY = moveY;
        this.moveZ = moveZ;
        this.onGround = onGround;
    }
}

