/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerEntityMetadataPacket
implements Packet {
    private int entityId;
    @NonNull
    private EntityMetadata[] metadata;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.metadata = EntityMetadata.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        EntityMetadata.write(out, this.metadata);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public EntityMetadata[] getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityMetadataPacket)) {
            return false;
        }
        ServerEntityMetadataPacket other = (ServerEntityMetadataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadata(), other.getMetadata());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityMetadataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getMetadata());
        return result;
    }

    public String toString() {
        return "ServerEntityMetadataPacket(entityId=" + this.getEntityId() + ", metadata=" + Arrays.deepToString(this.getMetadata()) + ")";
    }

    public ServerEntityMetadataPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityMetadataPacket(entityId, this.metadata);
    }

    public ServerEntityMetadataPacket withMetadata(@NonNull EntityMetadata[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata == metadata ? this : new ServerEntityMetadataPacket(this.entityId, metadata);
    }

    private ServerEntityMetadataPacket() {
    }

    public ServerEntityMetadataPacket(int entityId, @NonNull EntityMetadata[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.entityId = entityId;
        this.metadata = metadata;
    }
}

