/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerEntityHeadLookPacket
implements Packet {
    private int entityId;
    private float headYaw;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.headYaw = (float)(in.readByte() * 360) / 256.0f;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeByte((int)((byte)(this.headYaw * 256.0f / 360.0f)));
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityHeadLookPacket)) {
            return false;
        }
        ServerEntityHeadLookPacket other = (ServerEntityHeadLookPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Float.compare(this.getHeadYaw(), other.getHeadYaw()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityHeadLookPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getHeadYaw());
        return result;
    }

    public String toString() {
        return "ServerEntityHeadLookPacket(entityId=" + this.getEntityId() + ", headYaw=" + this.getHeadYaw() + ")";
    }

    public ServerEntityHeadLookPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityHeadLookPacket(entityId, this.headYaw);
    }

    public ServerEntityHeadLookPacket withHeadYaw(float headYaw) {
        return this.headYaw == headYaw ? this : new ServerEntityHeadLookPacket(this.entityId, headYaw);
    }

    private ServerEntityHeadLookPacket() {
    }

    public ServerEntityHeadLookPacket(int entityId, float headYaw) {
        this.entityId = entityId;
        this.headYaw = headYaw;
    }
}

