/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.EquipmentSlot;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Equipment;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;

public class ServerEntityEquipmentPacket
implements Packet {
    private int entityId;
    @NonNull
    private Equipment[] equipment;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        boolean hasNextEntry = true;
        ArrayList<Equipment> list = new ArrayList<Equipment>();
        while (hasNextEntry) {
            byte rawSlot = in.readByte();
            EquipmentSlot slot = MagicValues.key(EquipmentSlot.class, (byte)rawSlot & 0x7F);
            ItemStack item = ItemStack.read(in);
            list.add(new Equipment(slot, item));
            hasNextEntry = (rawSlot & 0x80) == 128;
        }
        this.equipment = list.toArray(new Equipment[0]);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        for (int i = 0; i < this.equipment.length; ++i) {
            int rawSlot = MagicValues.value(Integer.class, (Object)this.equipment[i].getSlot());
            if (i != this.equipment.length - 1) {
                rawSlot |= 0x80;
            }
            out.writeByte(rawSlot);
            ItemStack.write(out, this.equipment[i].getItem());
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Equipment[] getEquipment() {
        return this.equipment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityEquipmentPacket)) {
            return false;
        }
        ServerEntityEquipmentPacket other = (ServerEntityEquipmentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getEquipment(), other.getEquipment());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityEquipmentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getEquipment());
        return result;
    }

    public String toString() {
        return "ServerEntityEquipmentPacket(entityId=" + this.getEntityId() + ", equipment=" + Arrays.deepToString(this.getEquipment()) + ")";
    }

    public ServerEntityEquipmentPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityEquipmentPacket(entityId, this.equipment);
    }

    public ServerEntityEquipmentPacket withEquipment(@NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        return this.equipment == equipment ? this : new ServerEntityEquipmentPacket(this.entityId, equipment);
    }

    private ServerEntityEquipmentPacket() {
    }

    public ServerEntityEquipmentPacket(int entityId, @NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        this.entityId = entityId;
        this.equipment = equipment;
    }
}

