/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerEntityEffectPacket
implements Packet {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_SHOW_PARTICLES = 2;
    private int entityId;
    @NonNull
    private Effect effect;
    private int amplifier;
    private int duration;
    private boolean ambient;
    private boolean showParticles;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.effect = Effect.fromNetworkId(in.readByte());
        this.amplifier = in.readByte();
        this.duration = in.readVarInt();
        byte flags = in.readByte();
        this.ambient = (flags & 1) != 0;
        this.showParticles = (flags & 2) != 0;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeByte(Effect.toNetworkId(this.effect));
        out.writeByte(this.amplifier);
        out.writeVarInt(this.duration);
        int flags = 0;
        if (this.ambient) {
            flags |= 1;
        }
        if (this.showParticles) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityEffectPacket)) {
            return false;
        }
        ServerEntityEffectPacket other = (ServerEntityEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getAmplifier() != other.getAmplifier()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isAmbient() != other.isAmbient()) {
            return false;
        }
        if (this.isShowParticles() != other.isShowParticles()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        return !(this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAmplifier();
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isAmbient() ? 79 : 97);
        result = result * 59 + (this.isShowParticles() ? 79 : 97);
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerEntityEffectPacket(entityId=" + this.getEntityId() + ", effect=" + (Object)((Object)this.getEffect()) + ", amplifier=" + this.getAmplifier() + ", duration=" + this.getDuration() + ", ambient=" + this.isAmbient() + ", showParticles=" + this.isShowParticles() + ")";
    }

    public ServerEntityEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityEffectPacket(entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles);
    }

    public ServerEntityEffectPacket withEffect(@NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ServerEntityEffectPacket(this.entityId, effect, this.amplifier, this.duration, this.ambient, this.showParticles);
    }

    public ServerEntityEffectPacket withAmplifier(int amplifier) {
        return this.amplifier == amplifier ? this : new ServerEntityEffectPacket(this.entityId, this.effect, amplifier, this.duration, this.ambient, this.showParticles);
    }

    public ServerEntityEffectPacket withDuration(int duration) {
        return this.duration == duration ? this : new ServerEntityEffectPacket(this.entityId, this.effect, this.amplifier, duration, this.ambient, this.showParticles);
    }

    public ServerEntityEffectPacket withAmbient(boolean ambient) {
        return this.ambient == ambient ? this : new ServerEntityEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, ambient, this.showParticles);
    }

    public ServerEntityEffectPacket withShowParticles(boolean showParticles) {
        return this.showParticles == showParticles ? this : new ServerEntityEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, showParticles);
    }

    private ServerEntityEffectPacket() {
    }

    public ServerEntityEffectPacket(int entityId, @NonNull Effect effect, int amplifier, int duration, boolean ambient, boolean showParticles) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.showParticles = showParticles;
    }
}

