/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerEntityAttachPacket
implements Packet {
    private int entityId;
    private int attachedToId;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readInt();
        this.attachedToId = in.readInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.entityId);
        out.writeInt(this.attachedToId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getAttachedToId() {
        return this.attachedToId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityAttachPacket)) {
            return false;
        }
        ServerEntityAttachPacket other = (ServerEntityAttachPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return this.getAttachedToId() == other.getAttachedToId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityAttachPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAttachedToId();
        return result;
    }

    public String toString() {
        return "ServerEntityAttachPacket(entityId=" + this.getEntityId() + ", attachedToId=" + this.getAttachedToId() + ")";
    }

    public ServerEntityAttachPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityAttachPacket(entityId, this.attachedToId);
    }

    public ServerEntityAttachPacket withAttachedToId(int attachedToId) {
        return this.attachedToId == attachedToId ? this : new ServerEntityAttachPacket(this.entityId, attachedToId);
    }

    private ServerEntityAttachPacket() {
    }

    public ServerEntityAttachPacket(int entityId, int attachedToId) {
        this.entityId = entityId;
        this.attachedToId = attachedToId;
    }
}

