/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerTabCompletePacket
implements Packet {
    private int transactionId;
    private int start;
    private int length;
    @NonNull
    private String[] matches;
    @NonNull
    private Component[] tooltips;

    public ServerTabCompletePacket(int transactionId, int start, int length, @NonNull String[] matches, @NonNull Component[] tooltips) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        if (tooltips.length != matches.length) {
            throw new IllegalArgumentException("Length of matches and tooltips must be equal.");
        }
        this.transactionId = transactionId;
        this.start = start;
        this.length = length;
        this.matches = Arrays.copyOf(matches, matches.length);
        this.tooltips = Arrays.copyOf(tooltips, tooltips.length);
    }

    public void read(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.start = in.readVarInt();
        this.length = in.readVarInt();
        this.matches = new String[in.readVarInt()];
        this.tooltips = new Component[this.matches.length];
        for (int index = 0; index < this.matches.length; ++index) {
            this.matches[index] = in.readString();
            if (!in.readBoolean()) continue;
            this.tooltips[index] = DefaultComponentSerializer.get().deserialize((Object)in.readString());
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        out.writeVarInt(this.start);
        out.writeVarInt(this.length);
        out.writeVarInt(this.matches.length);
        for (int index = 0; index < this.matches.length; ++index) {
            out.writeString(this.matches[index]);
            Component tooltip = this.tooltips[index];
            if (tooltip != null) {
                out.writeBoolean(true);
                out.writeString((String)DefaultComponentSerializer.get().serialize(tooltip));
                continue;
            }
            out.writeBoolean(false);
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    @NonNull
    public String[] getMatches() {
        return this.matches;
    }

    @NonNull
    public Component[] getTooltips() {
        return this.tooltips;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerTabCompletePacket)) {
            return false;
        }
        ServerTabCompletePacket other = (ServerTabCompletePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMatches(), other.getMatches())) {
            return false;
        }
        return Arrays.deepEquals(this.getTooltips(), other.getTooltips());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerTabCompletePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getLength();
        result = result * 59 + Arrays.deepHashCode(this.getMatches());
        result = result * 59 + Arrays.deepHashCode(this.getTooltips());
        return result;
    }

    public String toString() {
        return "ServerTabCompletePacket(transactionId=" + this.getTransactionId() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", matches=" + Arrays.deepToString(this.getMatches()) + ", tooltips=" + Arrays.deepToString(this.getTooltips()) + ")";
    }

    public ServerTabCompletePacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerTabCompletePacket(transactionId, this.start, this.length, this.matches, this.tooltips);
    }

    public ServerTabCompletePacket withStart(int start) {
        return this.start == start ? this : new ServerTabCompletePacket(this.transactionId, start, this.length, this.matches, this.tooltips);
    }

    public ServerTabCompletePacket withLength(int length) {
        return this.length == length ? this : new ServerTabCompletePacket(this.transactionId, this.start, length, this.matches, this.tooltips);
    }

    public ServerTabCompletePacket withMatches(@NonNull String[] matches) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        return this.matches == matches ? this : new ServerTabCompletePacket(this.transactionId, this.start, this.length, matches, this.tooltips);
    }

    public ServerTabCompletePacket withTooltips(@NonNull Component[] tooltips) {
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        return this.tooltips == tooltips ? this : new ServerTabCompletePacket(this.transactionId, this.start, this.length, this.matches, tooltips);
    }

    private ServerTabCompletePacket() {
    }
}

