/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.UnmappedValueException;
import com.github.steveice10.mc.protocol.data.game.world.sound.BuiltinSound;
import com.github.steveice10.mc.protocol.data.game.world.sound.CustomSound;
import com.github.steveice10.mc.protocol.data.game.world.sound.Sound;
import com.github.steveice10.mc.protocol.data.game.world.sound.SoundCategory;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerStopSoundPacket
implements Packet {
    private static final int FLAG_CATEGORY = 1;
    private static final int FLAG_SOUND = 2;
    @NonNull
    private SoundCategory category;
    @NonNull
    private Sound sound;

    public void read(NetInput in) throws IOException {
        byte flags = in.readByte();
        this.category = (flags & 1) != 0 ? MagicValues.key(SoundCategory.class, in.readVarInt()) : null;
        if ((flags & 2) != 0) {
            String value = in.readString();
            try {
                this.sound = MagicValues.key(BuiltinSound.class, value);
            }
            catch (UnmappedValueException e) {
                this.sound = new CustomSound(value);
            }
        } else {
            this.sound = null;
        }
    }

    public void write(NetOutput out) throws IOException {
        int flags = 0;
        if (this.category != null) {
            flags |= 1;
        }
        if (this.sound != null) {
            flags |= 2;
        }
        out.writeByte(flags);
        if (this.category != null) {
            out.writeByte(MagicValues.value(Integer.class, (Object)this.category).intValue());
        }
        if (this.sound != null) {
            String value = "";
            if (this.sound instanceof CustomSound) {
                value = ((CustomSound)this.sound).getName();
            } else if (this.sound instanceof BuiltinSound) {
                value = MagicValues.value(String.class, this.sound);
            }
            out.writeString(value);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public SoundCategory getCategory() {
        return this.category;
    }

    @NonNull
    public Sound getSound() {
        return this.sound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerStopSoundPacket)) {
            return false;
        }
        ServerStopSoundPacket other = (ServerStopSoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerStopSoundPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "ServerStopSoundPacket(category=" + (Object)((Object)this.getCategory()) + ", sound=" + this.getSound() + ")";
    }

    public ServerStopSoundPacket withCategory(@NonNull SoundCategory category) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        return this.category == category ? this : new ServerStopSoundPacket(category, this.sound);
    }

    public ServerStopSoundPacket withSound(@NonNull Sound sound) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        return this.sound == sound ? this : new ServerStopSoundPacket(this.category, sound);
    }

    private ServerStopSoundPacket() {
    }

    public ServerStopSoundPacket(@NonNull SoundCategory category, @NonNull Sound sound) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        this.category = category;
        this.sound = sound;
    }
}

