/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerSetCooldownPacket
implements Packet {
    private int itemId;
    private int cooldownTicks;

    public void read(NetInput in) throws IOException {
        this.itemId = in.readVarInt();
        this.cooldownTicks = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.itemId);
        out.writeVarInt(this.cooldownTicks);
    }

    public boolean isPriority() {
        return false;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSetCooldownPacket)) {
            return false;
        }
        ServerSetCooldownPacket other = (ServerSetCooldownPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        return this.getCooldownTicks() == other.getCooldownTicks();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSetCooldownPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemId();
        result = result * 59 + this.getCooldownTicks();
        return result;
    }

    public String toString() {
        return "ServerSetCooldownPacket(itemId=" + this.getItemId() + ", cooldownTicks=" + this.getCooldownTicks() + ")";
    }

    public ServerSetCooldownPacket withItemId(int itemId) {
        return this.itemId == itemId ? this : new ServerSetCooldownPacket(itemId, this.cooldownTicks);
    }

    public ServerSetCooldownPacket withCooldownTicks(int cooldownTicks) {
        return this.cooldownTicks == cooldownTicks ? this : new ServerSetCooldownPacket(this.itemId, cooldownTicks);
    }

    private ServerSetCooldownPacket() {
    }

    public ServerSetCooldownPacket(int itemId, int cooldownTicks) {
        this.itemId = itemId;
        this.cooldownTicks = cooldownTicks;
    }
}

