/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerResourcePackSendPacket
implements Packet {
    @NonNull
    private String url;
    @NonNull
    private String hash;
    private boolean required;
    @Nullable
    private Component prompt;

    public void read(NetInput in) throws IOException {
        this.url = in.readString();
        this.hash = in.readString();
        this.required = in.readBoolean();
        if (in.readBoolean()) {
            this.prompt = DefaultComponentSerializer.get().deserialize((Object)in.readString());
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.url);
        out.writeString(this.hash);
        out.writeBoolean(this.required);
        out.writeBoolean(this.prompt != null);
        if (this.prompt != null) {
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.prompt));
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getHash() {
        return this.hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Nullable
    public Component getPrompt() {
        return this.prompt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerResourcePackSendPacket)) {
            return false;
        }
        ServerResourcePackSendPacket other = (ServerResourcePackSendPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Component this$prompt = this.getPrompt();
        Component other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerResourcePackSendPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Component $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }

    public String toString() {
        return "ServerResourcePackSendPacket(url=" + this.getUrl() + ", hash=" + this.getHash() + ", required=" + this.isRequired() + ", prompt=" + this.getPrompt() + ")";
    }

    public ServerResourcePackSendPacket withUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.url == url ? this : new ServerResourcePackSendPacket(url, this.hash, this.required, this.prompt);
    }

    public ServerResourcePackSendPacket withHash(@NonNull String hash) {
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        return this.hash == hash ? this : new ServerResourcePackSendPacket(this.url, hash, this.required, this.prompt);
    }

    public ServerResourcePackSendPacket withRequired(boolean required) {
        return this.required == required ? this : new ServerResourcePackSendPacket(this.url, this.hash, required, this.prompt);
    }

    public ServerResourcePackSendPacket withPrompt(@Nullable Component prompt) {
        return this.prompt == prompt ? this : new ServerResourcePackSendPacket(this.url, this.hash, this.required, prompt);
    }

    private ServerResourcePackSendPacket() {
    }

    public ServerResourcePackSendPacket(@NonNull String url, @NonNull String hash, boolean required, @Nullable Component prompt) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.prompt = prompt;
    }
}

