/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntry;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntryAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerPlayerListEntryPacket
implements Packet {
    @NonNull
    private PlayerListEntryAction action;
    @NonNull
    private PlayerListEntry[] entries;

    public void read(NetInput in) throws IOException {
        this.action = MagicValues.key(PlayerListEntryAction.class, in.readVarInt());
        this.entries = new PlayerListEntry[in.readVarInt()];
        for (int count = 0; count < this.entries.length; ++count) {
            UUID uuid = in.readUUID();
            GameProfile profile = this.action == PlayerListEntryAction.ADD_PLAYER ? new GameProfile(uuid, in.readString()) : new GameProfile(uuid, null);
            PlayerListEntry entry = null;
            switch (this.action) {
                case ADD_PLAYER: {
                    int properties = in.readVarInt();
                    ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
                    for (int index = 0; index < properties; ++index) {
                        String propertyName = in.readString();
                        String value = in.readString();
                        String signature = null;
                        if (in.readBoolean()) {
                            signature = in.readString();
                        }
                        propertyList.add(new GameProfile.Property(propertyName, value, signature));
                    }
                    profile.setProperties(propertyList);
                    int rawGameMode = in.readVarInt();
                    GameMode gameMode = MagicValues.key(GameMode.class, Math.max(rawGameMode, 0));
                    int ping = in.readVarInt();
                    Component displayName = null;
                    if (in.readBoolean()) {
                        displayName = DefaultComponentSerializer.get().deserialize((Object)in.readString());
                    }
                    entry = new PlayerListEntry(profile, gameMode, ping, displayName);
                    break;
                }
                case UPDATE_GAMEMODE: {
                    int rawGameMode = in.readVarInt();
                    GameMode mode = MagicValues.key(GameMode.class, Math.max(rawGameMode, 0));
                    entry = new PlayerListEntry(profile, mode);
                    break;
                }
                case UPDATE_LATENCY: {
                    int ping = in.readVarInt();
                    entry = new PlayerListEntry(profile, ping);
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    Component displayName = null;
                    if (in.readBoolean()) {
                        displayName = DefaultComponentSerializer.get().deserialize((Object)in.readString());
                    }
                    entry = new PlayerListEntry(profile, displayName);
                    break;
                }
                case REMOVE_PLAYER: {
                    entry = new PlayerListEntry(profile);
                }
            }
            this.entries[count] = entry;
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeVarInt(this.entries.length);
        block6: for (PlayerListEntry entry : this.entries) {
            out.writeUUID(entry.getProfile().getId());
            switch (this.action) {
                case ADD_PLAYER: {
                    out.writeString(entry.getProfile().getName());
                    out.writeVarInt(entry.getProfile().getProperties().size());
                    for (GameProfile.Property property : entry.getProfile().getProperties()) {
                        out.writeString(property.getName());
                        out.writeString(property.getValue());
                        out.writeBoolean(property.hasSignature());
                        if (!property.hasSignature()) continue;
                        out.writeString(property.getSignature());
                    }
                    out.writeVarInt(MagicValues.value(Integer.class, entry.getGameMode()).intValue());
                    out.writeVarInt(entry.getPing());
                    out.writeBoolean(entry.getDisplayName() != null);
                    if (entry.getDisplayName() == null) continue block6;
                    out.writeString((String)DefaultComponentSerializer.get().serialize(entry.getDisplayName()));
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    out.writeVarInt(MagicValues.value(Integer.class, entry.getGameMode()).intValue());
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    out.writeVarInt(entry.getPing());
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    out.writeBoolean(entry.getDisplayName() != null);
                    if (entry.getDisplayName() == null) continue block6;
                    out.writeString((String)DefaultComponentSerializer.get().serialize(entry.getDisplayName()));
                    continue block6;
                }
            }
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public PlayerListEntryAction getAction() {
        return this.action;
    }

    @NonNull
    public PlayerListEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayerListEntryPacket)) {
            return false;
        }
        ServerPlayerListEntryPacket other = (ServerPlayerListEntryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerListEntryAction this$action = this.getAction();
        PlayerListEntryAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayerListEntryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerListEntryAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public String toString() {
        return "ServerPlayerListEntryPacket(action=" + (Object)((Object)this.getAction()) + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public ServerPlayerListEntryPacket withAction(@NonNull PlayerListEntryAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerPlayerListEntryPacket(action, this.entries);
    }

    public ServerPlayerListEntryPacket withEntries(@NonNull PlayerListEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.entries == entries ? this : new ServerPlayerListEntryPacket(this.action, entries);
    }

    private ServerPlayerListEntryPacket() {
    }

    public ServerPlayerListEntryPacket(@NonNull PlayerListEntryAction action, @NonNull PlayerListEntry[] entries) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        this.action = action;
        this.entries = entries;
    }
}

