/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerJoinGamePacket
implements Packet {
    private static final int GAMEMODE_MASK = 7;
    private int entityId;
    private boolean hardcore;
    @NonNull
    private GameMode gameMode;
    private GameMode previousGamemode;
    private int worldCount;
    @NonNull
    private String[] worldNames;
    @NonNull
    private CompoundTag dimensionCodec;
    @NonNull
    private CompoundTag dimension;
    @NonNull
    private String worldName;
    private long hashedSeed;
    private int maxPlayers;
    private int viewDistance;
    private boolean reducedDebugInfo;
    private boolean enableRespawnScreen;
    private boolean debug;
    private boolean flat;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readInt();
        this.hardcore = in.readBoolean();
        int gameMode = in.readUnsignedByte();
        this.gameMode = MagicValues.key(GameMode.class, gameMode & 7);
        this.previousGamemode = MagicValues.key(GameMode.class, in.readUnsignedByte());
        this.worldCount = in.readVarInt();
        this.worldNames = new String[this.worldCount];
        for (int i = 0; i < this.worldCount; ++i) {
            this.worldNames[i] = in.readString();
        }
        this.dimensionCodec = NBT.read(in);
        this.dimension = NBT.read(in);
        this.worldName = in.readString();
        this.hashedSeed = in.readLong();
        this.maxPlayers = in.readVarInt();
        this.viewDistance = in.readVarInt();
        this.reducedDebugInfo = in.readBoolean();
        this.enableRespawnScreen = in.readBoolean();
        this.debug = in.readBoolean();
        this.flat = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.entityId);
        out.writeBoolean(this.hardcore);
        int gameMode = MagicValues.value(Integer.class, this.gameMode) & 7;
        out.writeByte(gameMode);
        out.writeByte(MagicValues.value(Integer.class, this.previousGamemode).intValue());
        out.writeVarInt(this.worldCount);
        for (String worldName : this.worldNames) {
            out.writeString(worldName);
        }
        NBT.write(out, this.dimensionCodec);
        NBT.write(out, this.dimension);
        out.writeString(this.worldName);
        out.writeLong(this.hashedSeed);
        out.writeVarInt(this.maxPlayers);
        out.writeVarInt(this.viewDistance);
        out.writeBoolean(this.reducedDebugInfo);
        out.writeBoolean(this.enableRespawnScreen);
        out.writeBoolean(this.debug);
        out.writeBoolean(this.flat);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    @NonNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    public GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    public int getWorldCount() {
        return this.worldCount;
    }

    @NonNull
    public String[] getWorldNames() {
        return this.worldNames;
    }

    @NonNull
    public CompoundTag getDimensionCodec() {
        return this.dimensionCodec;
    }

    @NonNull
    public CompoundTag getDimension() {
        return this.dimension;
    }

    @NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isEnableRespawnScreen() {
        return this.enableRespawnScreen;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerJoinGamePacket)) {
            return false;
        }
        ServerJoinGamePacket other = (ServerJoinGamePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.getWorldCount() != other.getWorldCount()) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isEnableRespawnScreen() != other.isEnableRespawnScreen()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        if (this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWorldNames(), other.getWorldNames())) {
            return false;
        }
        CompoundTag this$dimensionCodec = this.getDimensionCodec();
        CompoundTag other$dimensionCodec = other.getDimensionCodec();
        if (this$dimensionCodec == null ? other$dimensionCodec != null : !this$dimensionCodec.equals(other$dimensionCodec)) {
            return false;
        }
        CompoundTag this$dimension = this.getDimension();
        CompoundTag other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        return !(this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerJoinGamePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        result = result * 59 + this.getWorldCount();
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isEnableRespawnScreen() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWorldNames());
        CompoundTag $dimensionCodec = this.getDimensionCodec();
        result = result * 59 + ($dimensionCodec == null ? 43 : $dimensionCodec.hashCode());
        CompoundTag $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        return result;
    }

    public String toString() {
        return "ServerJoinGamePacket(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", gameMode=" + this.getGameMode() + ", previousGamemode=" + this.getPreviousGamemode() + ", worldCount=" + this.getWorldCount() + ", worldNames=" + Arrays.deepToString(this.getWorldNames()) + ", dimensionCodec=" + this.getDimensionCodec() + ", dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", maxPlayers=" + this.getMaxPlayers() + ", viewDistance=" + this.getViewDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", enableRespawnScreen=" + this.isEnableRespawnScreen() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ")";
    }

    public ServerJoinGamePacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerJoinGamePacket(entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withHardcore(boolean hardcore) {
        return this.hardcore == hardcore ? this : new ServerJoinGamePacket(this.entityId, hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withGameMode(@NonNull GameMode gameMode) {
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        return this.gameMode == gameMode ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withPreviousGamemode(GameMode previousGamemode) {
        return this.previousGamemode == previousGamemode ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withWorldCount(int worldCount) {
        return this.worldCount == worldCount ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withWorldNames(@NonNull String[] worldNames) {
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        return this.worldNames == worldNames ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withDimensionCodec(@NonNull CompoundTag dimensionCodec) {
        if (dimensionCodec == null) {
            throw new NullPointerException("dimensionCodec is marked non-null but is null");
        }
        return this.dimensionCodec == dimensionCodec ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withDimension(@NonNull CompoundTag dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        return this.dimension == dimension ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withWorldName(@NonNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        return this.worldName == worldName ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withHashedSeed(long hashedSeed) {
        return this.hashedSeed == hashedSeed ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withMaxPlayers(int maxPlayers) {
        return this.maxPlayers == maxPlayers ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withViewDistance(int viewDistance) {
        return this.viewDistance == viewDistance ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withReducedDebugInfo(boolean reducedDebugInfo) {
        return this.reducedDebugInfo == reducedDebugInfo ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, reducedDebugInfo, this.enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withEnableRespawnScreen(boolean enableRespawnScreen) {
        return this.enableRespawnScreen == enableRespawnScreen ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, enableRespawnScreen, this.debug, this.flat);
    }

    public ServerJoinGamePacket withDebug(boolean debug) {
        return this.debug == debug ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, debug, this.flat);
    }

    public ServerJoinGamePacket withFlat(boolean flat) {
        return this.flat == flat ? this : new ServerJoinGamePacket(this.entityId, this.hardcore, this.gameMode, this.previousGamemode, this.worldCount, this.worldNames, this.dimensionCodec, this.dimension, this.worldName, this.hashedSeed, this.maxPlayers, this.viewDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.debug, flat);
    }

    private ServerJoinGamePacket() {
    }

    public ServerJoinGamePacket(int entityId, boolean hardcore, @NonNull GameMode gameMode, GameMode previousGamemode, int worldCount, @NonNull String[] worldNames, @NonNull CompoundTag dimensionCodec, @NonNull CompoundTag dimension, @NonNull String worldName, long hashedSeed, int maxPlayers, int viewDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean debug, boolean flat) {
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        if (dimensionCodec == null) {
            throw new NullPointerException("dimensionCodec is marked non-null but is null");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.entityId = entityId;
        this.hardcore = hardcore;
        this.gameMode = gameMode;
        this.previousGamemode = previousGamemode;
        this.worldCount = worldCount;
        this.worldNames = worldNames;
        this.dimensionCodec = dimensionCodec;
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.maxPlayers = maxPlayers;
        this.viewDistance = viewDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.enableRespawnScreen = enableRespawnScreen;
        this.debug = debug;
        this.flat = flat;
    }
}

