/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerDifficultyPacket
implements Packet {
    @NonNull
    private Difficulty difficulty;
    private boolean difficultyLocked;

    public void read(NetInput in) throws IOException {
        this.difficulty = MagicValues.key(Difficulty.class, in.readUnsignedByte());
        this.difficultyLocked = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(MagicValues.value(Integer.class, (Object)this.difficulty).intValue());
        out.writeBoolean(this.difficultyLocked);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerDifficultyPacket)) {
            return false;
        }
        ServerDifficultyPacket other = (ServerDifficultyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDifficultyLocked() != other.isDifficultyLocked()) {
            return false;
        }
        Difficulty this$difficulty = this.getDifficulty();
        Difficulty other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerDifficultyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDifficultyLocked() ? 79 : 97);
        Difficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerDifficultyPacket(difficulty=" + (Object)((Object)this.getDifficulty()) + ", difficultyLocked=" + this.isDifficultyLocked() + ")";
    }

    public ServerDifficultyPacket withDifficulty(@NonNull Difficulty difficulty) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        return this.difficulty == difficulty ? this : new ServerDifficultyPacket(difficulty, this.difficultyLocked);
    }

    public ServerDifficultyPacket withDifficultyLocked(boolean difficultyLocked) {
        return this.difficultyLocked == difficultyLocked ? this : new ServerDifficultyPacket(this.difficulty, difficultyLocked);
    }

    private ServerDifficultyPacket() {
    }

    public ServerDifficultyPacket(@NonNull Difficulty difficulty, boolean difficultyLocked) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        this.difficulty = difficulty;
        this.difficultyLocked = difficultyLocked;
    }
}

