/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.command.CommandNode;
import com.github.steveice10.mc.protocol.data.game.command.CommandParser;
import com.github.steveice10.mc.protocol.data.game.command.CommandType;
import com.github.steveice10.mc.protocol.data.game.command.SuggestionType;
import com.github.steveice10.mc.protocol.data.game.command.properties.CommandProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.DoubleProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.EntityProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.FloatProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.IntegerProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.LongProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.RangeProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.ScoreHolderProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.StringProperties;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerDeclareCommandsPacket
implements Packet {
    private static final int FLAG_TYPE_MASK = 3;
    private static final int FLAG_EXECUTABLE = 4;
    private static final int FLAG_REDIRECT = 8;
    private static final int FLAG_SUGGESTION_TYPE = 16;
    private static final int NUMBER_FLAG_MIN_DEFINED = 1;
    private static final int NUMBER_FLAG_MAX_DEFINED = 2;
    private static final int ENTITY_FLAG_SINGLE_TARGET = 1;
    private static final int ENTITY_FLAG_PLAYERS_ONLY = 2;
    @NonNull
    private CommandNode[] nodes;
    private int firstNodeIndex;

    public void read(NetInput in) throws IOException {
        this.nodes = new CommandNode[in.readVarInt()];
        for (int i = 0; i < this.nodes.length; ++i) {
            byte flags = in.readByte();
            CommandType type = MagicValues.key(CommandType.class, flags & 3);
            boolean executable = (flags & 4) != 0;
            int[] children = new int[in.readVarInt()];
            for (int j = 0; j < children.length; ++j) {
                children[j] = in.readVarInt();
            }
            int redirectIndex = -1;
            if ((flags & 8) != 0) {
                redirectIndex = in.readVarInt();
            }
            String name = null;
            if (type == CommandType.LITERAL || type == CommandType.ARGUMENT) {
                name = in.readString();
            }
            CommandParser parser = null;
            CommandProperties properties = null;
            if (type == CommandType.ARGUMENT) {
                String identifier = Identifier.formalize(in.readString());
                if (identifier.equals("minecraft:")) continue;
                parser = MagicValues.key(CommandParser.class, identifier);
                switch (parser) {
                    case DOUBLE: {
                        byte numberFlags = in.readByte();
                        double min = -1.7976931348623157E308;
                        double max = Double.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readDouble();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readDouble();
                        }
                        properties = new DoubleProperties(min, max);
                        break;
                    }
                    case FLOAT: {
                        byte numberFlags = in.readByte();
                        float min = -3.4028235E38f;
                        float max = Float.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readFloat();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readFloat();
                        }
                        properties = new FloatProperties(min, max);
                        break;
                    }
                    case INTEGER: {
                        byte numberFlags = in.readByte();
                        int min = Integer.MIN_VALUE;
                        int max = Integer.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readInt();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readInt();
                        }
                        properties = new IntegerProperties(min, max);
                        break;
                    }
                    case LONG: {
                        byte numberFlags = in.readByte();
                        long min = (numberFlags & 1) != 0 ? in.readLong() : Long.MIN_VALUE;
                        long max = (numberFlags & 2) != 0 ? in.readLong() : Long.MAX_VALUE;
                        properties = new LongProperties(min, max);
                        break;
                    }
                    case STRING: {
                        properties = MagicValues.key(StringProperties.class, in.readVarInt());
                        break;
                    }
                    case ENTITY: {
                        byte entityFlags = in.readByte();
                        properties = new EntityProperties((entityFlags & 1) != 0, (entityFlags & 2) != 0);
                        break;
                    }
                    case SCORE_HOLDER: {
                        properties = new ScoreHolderProperties(in.readBoolean());
                        break;
                    }
                    case RANGE: {
                        properties = new RangeProperties(in.readBoolean());
                        break;
                    }
                }
            }
            SuggestionType suggestionType = null;
            if ((flags & 0x10) != 0) {
                suggestionType = MagicValues.key(SuggestionType.class, Identifier.formalize(in.readString()));
            }
            this.nodes[i] = new CommandNode(type, executable, children, redirectIndex, name, parser, properties, suggestionType);
        }
        this.firstNodeIndex = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.nodes.length);
        for (CommandNode node : this.nodes) {
            int flags = MagicValues.value(Integer.class, (Object)node.getType()) & 3;
            if (node.isExecutable()) {
                flags |= 4;
            }
            if (node.getRedirectIndex() != -1) {
                flags |= 8;
            }
            if (node.getSuggestionType() != null) {
                flags |= 0x10;
            }
            out.writeByte(flags);
            out.writeVarInt(node.getChildIndices().length);
            for (int childIndex : node.getChildIndices()) {
                out.writeVarInt(childIndex);
            }
            if (node.getRedirectIndex() != -1) {
                out.writeVarInt(node.getRedirectIndex());
            }
            if (node.getType() == CommandType.LITERAL || node.getType() == CommandType.ARGUMENT) {
                out.writeString(node.getName());
            }
            if (node.getType() == CommandType.ARGUMENT) {
                out.writeString(MagicValues.value(String.class, (Object)node.getParser()));
                switch (node.getParser()) {
                    case DOUBLE: {
                        CommandProperties properties = (DoubleProperties)node.getProperties();
                        int numberFlags = 0;
                        if (((DoubleProperties)properties).getMin() != -1.7976931348623157E308) {
                            numberFlags |= 1;
                        }
                        if (((DoubleProperties)properties).getMax() != Double.MAX_VALUE) {
                            numberFlags |= 2;
                        }
                        out.writeByte(numberFlags);
                        if ((numberFlags & 1) != 0) {
                            out.writeDouble(((DoubleProperties)properties).getMin());
                        }
                        if ((numberFlags & 2) == 0) break;
                        out.writeDouble(((DoubleProperties)properties).getMax());
                        break;
                    }
                    case FLOAT: {
                        CommandProperties properties = (FloatProperties)node.getProperties();
                        int numberFlags = 0;
                        if (((FloatProperties)properties).getMin() != -3.4028235E38f) {
                            numberFlags |= 1;
                        }
                        if (((FloatProperties)properties).getMax() != Float.MAX_VALUE) {
                            numberFlags |= 2;
                        }
                        out.writeByte(numberFlags);
                        if ((numberFlags & 1) != 0) {
                            out.writeFloat(((FloatProperties)properties).getMin());
                        }
                        if ((numberFlags & 2) == 0) break;
                        out.writeFloat(((FloatProperties)properties).getMax());
                        break;
                    }
                    case INTEGER: {
                        CommandProperties properties = (IntegerProperties)node.getProperties();
                        int numberFlags = 0;
                        if (((IntegerProperties)properties).getMin() != Integer.MIN_VALUE) {
                            numberFlags |= 1;
                        }
                        if (((IntegerProperties)properties).getMax() != Integer.MAX_VALUE) {
                            numberFlags |= 2;
                        }
                        out.writeByte(numberFlags);
                        if ((numberFlags & 1) != 0) {
                            out.writeInt(((IntegerProperties)properties).getMin());
                        }
                        if ((numberFlags & 2) == 0) break;
                        out.writeInt(((IntegerProperties)properties).getMax());
                        break;
                    }
                    case LONG: {
                        CommandProperties properties = (LongProperties)node.getProperties();
                        int numberFlags = 0;
                        if (((LongProperties)properties).getMin() != Long.MIN_VALUE) {
                            numberFlags |= 1;
                        }
                        if (((LongProperties)properties).getMax() != Long.MAX_VALUE) {
                            numberFlags |= 2;
                        }
                        out.writeByte(numberFlags);
                        if ((numberFlags & 1) != 0) {
                            out.writeLong(((LongProperties)properties).getMin());
                        }
                        if ((numberFlags & 2) == 0) break;
                        out.writeLong(((LongProperties)properties).getMax());
                        break;
                    }
                    case STRING: {
                        out.writeVarInt(MagicValues.value(Integer.class, node.getProperties()).intValue());
                        break;
                    }
                    case ENTITY: {
                        CommandProperties properties = (EntityProperties)node.getProperties();
                        int entityFlags = 0;
                        if (((EntityProperties)properties).isSingleTarget()) {
                            entityFlags |= 1;
                        }
                        if (((EntityProperties)properties).isPlayersOnly()) {
                            entityFlags |= 2;
                        }
                        out.writeByte(entityFlags);
                        break;
                    }
                    case SCORE_HOLDER: {
                        out.writeBoolean(((ScoreHolderProperties)node.getProperties()).isAllowMultiple());
                        break;
                    }
                    case RANGE: {
                        out.writeBoolean(((RangeProperties)node.getProperties()).isAllowDecimals());
                        break;
                    }
                }
            }
            if (node.getSuggestionType() == null) continue;
            out.writeString(MagicValues.value(String.class, (Object)node.getSuggestionType()));
        }
        out.writeVarInt(this.firstNodeIndex);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public CommandNode[] getNodes() {
        return this.nodes;
    }

    public int getFirstNodeIndex() {
        return this.firstNodeIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerDeclareCommandsPacket)) {
            return false;
        }
        ServerDeclareCommandsPacket other = (ServerDeclareCommandsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFirstNodeIndex() != other.getFirstNodeIndex()) {
            return false;
        }
        return Arrays.deepEquals(this.getNodes(), other.getNodes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerDeclareCommandsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFirstNodeIndex();
        result = result * 59 + Arrays.deepHashCode(this.getNodes());
        return result;
    }

    public String toString() {
        return "ServerDeclareCommandsPacket(nodes=" + Arrays.deepToString(this.getNodes()) + ", firstNodeIndex=" + this.getFirstNodeIndex() + ")";
    }

    public ServerDeclareCommandsPacket withNodes(@NonNull CommandNode[] nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        return this.nodes == nodes ? this : new ServerDeclareCommandsPacket(nodes, this.firstNodeIndex);
    }

    public ServerDeclareCommandsPacket withFirstNodeIndex(int firstNodeIndex) {
        return this.firstNodeIndex == firstNodeIndex ? this : new ServerDeclareCommandsPacket(this.nodes, firstNodeIndex);
    }

    private ServerDeclareCommandsPacket() {
    }

    public ServerDeclareCommandsPacket(@NonNull CommandNode[] nodes, int firstNodeIndex) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        this.nodes = nodes;
        this.firstNodeIndex = firstNodeIndex;
    }
}

