/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.BossBarAction;
import com.github.steveice10.mc.protocol.data.game.BossBarColor;
import com.github.steveice10.mc.protocol.data.game.BossBarDivision;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerBossBarPacket
implements Packet {
    @NonNull
    private UUID uuid;
    @NonNull
    private BossBarAction action;
    private Component title;
    private float health;
    private BossBarColor color;
    private BossBarDivision division;
    private boolean darkenSky;
    private boolean playEndMusic;
    private boolean showFog;

    public ServerBossBarPacket(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.REMOVE;
    }

    public ServerBossBarPacket(@NonNull UUID uuid, @NonNull Component title) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.UPDATE_TITLE;
        this.title = title;
    }

    public ServerBossBarPacket(@NonNull UUID uuid, float health) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.UPDATE_HEALTH;
        this.health = health;
    }

    public ServerBossBarPacket(@NonNull UUID uuid, @NonNull BossBarColor color, @NonNull BossBarDivision division) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (division == null) {
            throw new NullPointerException("division is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.UPDATE_STYLE;
        this.color = color;
        this.division = division;
    }

    public ServerBossBarPacket(@NonNull UUID uuid, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.UPDATE_FLAGS;
        this.darkenSky = darkenSky;
        this.playEndMusic = playEndMusic;
        this.showFog = showFog;
    }

    public ServerBossBarPacket(@NonNull UUID uuid, @NonNull Component title, float health, @NonNull BossBarColor color, @NonNull BossBarDivision division, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (division == null) {
            throw new NullPointerException("division is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.ADD;
        this.title = title;
        this.health = health;
        this.color = color;
        this.division = division;
        this.darkenSky = darkenSky;
        this.playEndMusic = playEndMusic;
        this.showFog = showFog;
    }

    public void read(NetInput in) throws IOException {
        this.uuid = in.readUUID();
        this.action = MagicValues.key(BossBarAction.class, in.readVarInt());
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_TITLE) {
            this.title = DefaultComponentSerializer.get().deserialize((Object)in.readString());
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_HEALTH) {
            this.health = in.readFloat();
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_STYLE) {
            this.color = MagicValues.key(BossBarColor.class, in.readVarInt());
            this.division = MagicValues.key(BossBarDivision.class, in.readVarInt());
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_FLAGS) {
            int flags = in.readUnsignedByte();
            this.darkenSky = (flags & 1) == 1;
            this.playEndMusic = (flags & 2) == 2;
            this.showFog = (flags & 4) == 4;
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeUUID(this.uuid);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_TITLE) {
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.title));
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_HEALTH) {
            out.writeFloat(this.health);
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_STYLE) {
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.color).intValue());
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.division).intValue());
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_FLAGS) {
            int flags = 0;
            if (this.darkenSky) {
                flags |= 1;
            }
            if (this.playEndMusic) {
                flags |= 2;
            }
            if (this.showFog) {
                flags |= 4;
            }
            out.writeByte(flags);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public BossBarAction getAction() {
        return this.action;
    }

    public Component getTitle() {
        return this.title;
    }

    public float getHealth() {
        return this.health;
    }

    public BossBarColor getColor() {
        return this.color;
    }

    public BossBarDivision getDivision() {
        return this.division;
    }

    public boolean isDarkenSky() {
        return this.darkenSky;
    }

    public boolean isPlayEndMusic() {
        return this.playEndMusic;
    }

    public boolean isShowFog() {
        return this.showFog;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerBossBarPacket)) {
            return false;
        }
        ServerBossBarPacket other = (ServerBossBarPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getHealth(), other.getHealth()) != 0) {
            return false;
        }
        if (this.isDarkenSky() != other.isDarkenSky()) {
            return false;
        }
        if (this.isPlayEndMusic() != other.isPlayEndMusic()) {
            return false;
        }
        if (this.isShowFog() != other.isShowFog()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        BossBarAction this$action = this.getAction();
        BossBarAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$title = this.getTitle();
        Component other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        BossBarColor this$color = this.getColor();
        BossBarColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        BossBarDivision this$division = this.getDivision();
        BossBarDivision other$division = other.getDivision();
        return !(this$division == null ? other$division != null : !((Object)((Object)this$division)).equals((Object)other$division));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerBossBarPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getHealth());
        result = result * 59 + (this.isDarkenSky() ? 79 : 97);
        result = result * 59 + (this.isPlayEndMusic() ? 79 : 97);
        result = result * 59 + (this.isShowFog() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        BossBarAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        BossBarColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        BossBarDivision $division = this.getDivision();
        result = result * 59 + ($division == null ? 43 : ((Object)((Object)$division)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerBossBarPacket(uuid=" + this.getUuid() + ", action=" + (Object)((Object)this.getAction()) + ", title=" + this.getTitle() + ", health=" + this.getHealth() + ", color=" + (Object)((Object)this.getColor()) + ", division=" + (Object)((Object)this.getDivision()) + ", darkenSky=" + this.isDarkenSky() + ", playEndMusic=" + this.isPlayEndMusic() + ", showFog=" + this.isShowFog() + ")";
    }

    public ServerBossBarPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ServerBossBarPacket(uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withAction(@NonNull BossBarAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerBossBarPacket(this.uuid, action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withTitle(Component title) {
        return this.title == title ? this : new ServerBossBarPacket(this.uuid, this.action, title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withHealth(float health) {
        return this.health == health ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withColor(BossBarColor color) {
        return this.color == color ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, this.health, color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withDivision(BossBarDivision division) {
        return this.division == division ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, this.health, this.color, division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withDarkenSky(boolean darkenSky) {
        return this.darkenSky == darkenSky ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, darkenSky, this.playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withPlayEndMusic(boolean playEndMusic) {
        return this.playEndMusic == playEndMusic ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, playEndMusic, this.showFog);
    }

    public ServerBossBarPacket withShowFog(boolean showFog) {
        return this.showFog == showFog ? this : new ServerBossBarPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, showFog);
    }

    private ServerBossBarPacket() {
    }

    private ServerBossBarPacket(@NonNull UUID uuid, @NonNull BossBarAction action, Component title, float health, BossBarColor color, BossBarDivision division, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = action;
        this.title = title;
        this.health = health;
        this.color = color;
        this.division = division;
        this.darkenSky = darkenSky;
        this.playEndMusic = playEndMusic;
        this.showFog = showFog;
    }
}

