/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.world;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientUpdateSignPacket
implements Packet {
    @NonNull
    private Position position;
    @NonNull
    private String[] lines;

    public ClientUpdateSignPacket(@NonNull Position position, @NonNull String[] lines) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.length != 4) {
            throw new IllegalArgumentException("Lines must contain exactly 4 strings.");
        }
        this.position = position;
        this.lines = Arrays.copyOf(lines, lines.length);
    }

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.lines = new String[4];
        for (int count = 0; count < this.lines.length; ++count) {
            this.lines[count] = in.readString();
        }
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        for (String line : this.lines) {
            out.writeString(line);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public String[] getLines() {
        return this.lines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientUpdateSignPacket)) {
            return false;
        }
        ClientUpdateSignPacket other = (ClientUpdateSignPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        return Arrays.deepEquals(this.getLines(), other.getLines());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientUpdateSignPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLines());
        return result;
    }

    public String toString() {
        return "ClientUpdateSignPacket(position=" + this.getPosition() + ", lines=" + Arrays.deepToString(this.getLines()) + ")";
    }

    public ClientUpdateSignPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientUpdateSignPacket(position, this.lines);
    }

    public ClientUpdateSignPacket withLines(@NonNull String[] lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return this.lines == lines ? this : new ClientUpdateSignPacket(this.position, lines);
    }

    private ClientUpdateSignPacket() {
    }
}

