/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.world;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientSteerVehiclePacket
implements Packet {
    private static final int FLAG_JUMP = 1;
    private static final int FLAG_DISMOUNT = 2;
    private float sideways;
    private float forward;
    private boolean jump;
    private boolean dismount;

    public void read(NetInput in) throws IOException {
        this.sideways = in.readFloat();
        this.forward = in.readFloat();
        int flags = in.readUnsignedByte();
        this.jump = (flags & 1) != 0;
        this.dismount = (flags & 2) != 0;
    }

    public void write(NetOutput out) throws IOException {
        out.writeFloat(this.sideways);
        out.writeFloat(this.forward);
        int flags = 0;
        if (this.jump) {
            flags |= 1;
        }
        if (this.dismount) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    public boolean isPriority() {
        return false;
    }

    public float getSideways() {
        return this.sideways;
    }

    public float getForward() {
        return this.forward;
    }

    public boolean isJump() {
        return this.jump;
    }

    public boolean isDismount() {
        return this.dismount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSteerVehiclePacket)) {
            return false;
        }
        ClientSteerVehiclePacket other = (ClientSteerVehiclePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getSideways(), other.getSideways()) != 0) {
            return false;
        }
        if (Float.compare(this.getForward(), other.getForward()) != 0) {
            return false;
        }
        if (this.isJump() != other.isJump()) {
            return false;
        }
        return this.isDismount() == other.isDismount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientSteerVehiclePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getSideways());
        result = result * 59 + Float.floatToIntBits(this.getForward());
        result = result * 59 + (this.isJump() ? 79 : 97);
        result = result * 59 + (this.isDismount() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClientSteerVehiclePacket(sideways=" + this.getSideways() + ", forward=" + this.getForward() + ", jump=" + this.isJump() + ", dismount=" + this.isDismount() + ")";
    }

    public ClientSteerVehiclePacket withSideways(float sideways) {
        return this.sideways == sideways ? this : new ClientSteerVehiclePacket(sideways, this.forward, this.jump, this.dismount);
    }

    public ClientSteerVehiclePacket withForward(float forward) {
        return this.forward == forward ? this : new ClientSteerVehiclePacket(this.sideways, forward, this.jump, this.dismount);
    }

    public ClientSteerVehiclePacket withJump(boolean jump) {
        return this.jump == jump ? this : new ClientSteerVehiclePacket(this.sideways, this.forward, jump, this.dismount);
    }

    public ClientSteerVehiclePacket withDismount(boolean dismount) {
        return this.dismount == dismount ? this : new ClientSteerVehiclePacket(this.sideways, this.forward, this.jump, dismount);
    }

    private ClientSteerVehiclePacket() {
    }

    public ClientSteerVehiclePacket(float sideways, float forward, boolean jump, boolean dismount) {
        this.sideways = sideways;
        this.forward = forward;
        this.jump = jump;
        this.dismount = dismount;
    }
}

