/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.world;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientGenerateStructuresPacket
implements Packet {
    @NonNull
    private Position position;
    private int levels;
    private boolean keepJigsaws;

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.levels = in.readVarInt();
        this.keepJigsaws = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeVarInt(this.levels);
        out.writeBoolean(this.keepJigsaws);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public int getLevels() {
        return this.levels;
    }

    public boolean isKeepJigsaws() {
        return this.keepJigsaws;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientGenerateStructuresPacket)) {
            return false;
        }
        ClientGenerateStructuresPacket other = (ClientGenerateStructuresPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevels() != other.getLevels()) {
            return false;
        }
        if (this.isKeepJigsaws() != other.isKeepJigsaws()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientGenerateStructuresPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevels();
        result = result * 59 + (this.isKeepJigsaws() ? 79 : 97);
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "ClientGenerateStructuresPacket(position=" + this.getPosition() + ", levels=" + this.getLevels() + ", keepJigsaws=" + this.isKeepJigsaws() + ")";
    }

    public ClientGenerateStructuresPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientGenerateStructuresPacket(position, this.levels, this.keepJigsaws);
    }

    public ClientGenerateStructuresPacket withLevels(int levels) {
        return this.levels == levels ? this : new ClientGenerateStructuresPacket(this.position, levels, this.keepJigsaws);
    }

    public ClientGenerateStructuresPacket withKeepJigsaws(boolean keepJigsaws) {
        return this.keepJigsaws == keepJigsaws ? this : new ClientGenerateStructuresPacket(this.position, this.levels, keepJigsaws);
    }

    private ClientGenerateStructuresPacket() {
    }

    public ClientGenerateStructuresPacket(@NonNull Position position, int levels, boolean keepJigsaws) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.levels = levels;
        this.keepJigsaws = keepJigsaws;
    }
}

