/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.world;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientEntityNBTRequestPacket
implements Packet {
    private int transactionId;
    private int entityId;

    public void read(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.entityId = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        out.writeVarInt(this.entityId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientEntityNBTRequestPacket)) {
            return false;
        }
        ClientEntityNBTRequestPacket other = (ClientEntityNBTRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientEntityNBTRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public String toString() {
        return "ClientEntityNBTRequestPacket(transactionId=" + this.getTransactionId() + ", entityId=" + this.getEntityId() + ")";
    }

    public ClientEntityNBTRequestPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientEntityNBTRequestPacket(transactionId, this.entityId);
    }

    public ClientEntityNBTRequestPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientEntityNBTRequestPacket(this.transactionId, entityId);
    }

    private ClientEntityNBTRequestPacket() {
    }

    public ClientEntityNBTRequestPacket(int transactionId, int entityId) {
        this.transactionId = transactionId;
        this.entityId = entityId;
    }
}

