/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.world;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientBlockNBTRequestPacket
implements Packet {
    private int transactionId;
    @NonNull
    private Position position;

    public void read(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.position = Position.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        Position.write(out, this.position);
    }

    public boolean isPriority() {
        return false;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientBlockNBTRequestPacket)) {
            return false;
        }
        ClientBlockNBTRequestPacket other = (ClientBlockNBTRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientBlockNBTRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "ClientBlockNBTRequestPacket(transactionId=" + this.getTransactionId() + ", position=" + this.getPosition() + ")";
    }

    public ClientBlockNBTRequestPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientBlockNBTRequestPacket(transactionId, this.position);
    }

    public ClientBlockNBTRequestPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientBlockNBTRequestPacket(this.transactionId, position);
    }

    private ClientBlockNBTRequestPacket() {
    }

    public ClientBlockNBTRequestPacket(int transactionId, @NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.position = position;
    }
}

