/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.window.ClickItemParam;
import com.github.steveice10.mc.protocol.data.game.window.CreativeGrabParam;
import com.github.steveice10.mc.protocol.data.game.window.DropItemParam;
import com.github.steveice10.mc.protocol.data.game.window.FillStackParam;
import com.github.steveice10.mc.protocol.data.game.window.MoveToHotbarParam;
import com.github.steveice10.mc.protocol.data.game.window.ShiftClickItemParam;
import com.github.steveice10.mc.protocol.data.game.window.SpreadItemParam;
import com.github.steveice10.mc.protocol.data.game.window.WindowAction;
import com.github.steveice10.mc.protocol.data.game.window.WindowActionParam;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import io.netty.util.collection.IntObjectHashMap;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class ClientWindowActionPacket
implements Packet {
    public static final int CLICK_OUTSIDE_NOT_HOLDING_SLOT = -999;
    private int windowId;
    private int stateId;
    private int slot;
    private WindowAction action;
    private WindowActionParam param;
    private ItemStack carriedItem;
    @NonNull
    private Map<Integer, ItemStack> changedSlots;

    public ClientWindowActionPacket(int windowId, int stateId, int slot, WindowAction action, WindowActionParam param, ItemStack carriedItem, @NotNull Map<Integer, ItemStack> changedSlots) {
        if ((param == DropItemParam.LEFT_CLICK_OUTSIDE_NOT_HOLDING || param == DropItemParam.RIGHT_CLICK_OUTSIDE_NOT_HOLDING) && slot != 999) {
            throw new IllegalArgumentException("Slot must be -999 with param LEFT_CLICK_OUTSIDE_NOT_HOLDING or RIGHT_CLICK_OUTSIDE_NOT_HOLDING");
        }
        this.windowId = windowId;
        this.stateId = stateId;
        this.slot = slot;
        this.action = action;
        this.param = param;
        this.carriedItem = carriedItem;
        this.changedSlots = changedSlots;
    }

    public void read(NetInput in) throws IOException {
        this.windowId = in.readByte();
        this.stateId = in.readVarInt();
        this.slot = in.readShort();
        byte param = in.readByte();
        this.action = MagicValues.key(WindowAction.class, in.readByte());
        if (this.action == WindowAction.CLICK_ITEM) {
            this.param = MagicValues.key(ClickItemParam.class, param);
        } else if (this.action == WindowAction.SHIFT_CLICK_ITEM) {
            this.param = MagicValues.key(ShiftClickItemParam.class, param);
        } else if (this.action == WindowAction.MOVE_TO_HOTBAR_SLOT) {
            this.param = MagicValues.key(MoveToHotbarParam.class, param);
        } else if (this.action == WindowAction.CREATIVE_GRAB_MAX_STACK) {
            this.param = MagicValues.key(CreativeGrabParam.class, param);
        } else if (this.action == WindowAction.DROP_ITEM) {
            this.param = MagicValues.key(DropItemParam.class, param + (this.slot != -999 ? 2 : 0));
        } else if (this.action == WindowAction.SPREAD_ITEM) {
            this.param = MagicValues.key(SpreadItemParam.class, param);
        } else if (this.action == WindowAction.FILL_STACK) {
            this.param = MagicValues.key(FillStackParam.class, param);
        }
        int changedItemsSize = in.readVarInt();
        this.changedSlots = new IntObjectHashMap(changedItemsSize);
        for (int i = 0; i < changedItemsSize; ++i) {
            short key = in.readShort();
            ItemStack value = ItemStack.read(in);
            this.changedSlots.put(Integer.valueOf(key), value);
        }
        this.carriedItem = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeVarInt(this.stateId);
        out.writeShort(this.slot);
        int param = MagicValues.value(Integer.class, this.param);
        if (this.action == WindowAction.DROP_ITEM) {
            param %= 2;
        }
        out.writeByte(param);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeVarInt(this.changedSlots.size());
        for (Map.Entry<Integer, ItemStack> pair : this.changedSlots.entrySet()) {
            out.writeShort(pair.getKey().intValue());
            ItemStack.write(out, pair.getValue());
        }
        ItemStack.write(out, this.carriedItem);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    public WindowAction getAction() {
        return this.action;
    }

    public WindowActionParam getParam() {
        return this.param;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    @NonNull
    public Map<Integer, ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientWindowActionPacket)) {
            return false;
        }
        ClientWindowActionPacket other = (ClientWindowActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        WindowAction this$action = this.getAction();
        WindowAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        WindowActionParam this$param = this.getParam();
        WindowActionParam other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        if (this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem)) {
            return false;
        }
        Map<Integer, ItemStack> this$changedSlots = this.getChangedSlots();
        Map<Integer, ItemStack> other$changedSlots = other.getChangedSlots();
        return !(this$changedSlots == null ? other$changedSlots != null : !((Object)this$changedSlots).equals(other$changedSlots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientWindowActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        WindowAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        WindowActionParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        Map<Integer, ItemStack> $changedSlots = this.getChangedSlots();
        result = result * 59 + ($changedSlots == null ? 43 : ((Object)$changedSlots).hashCode());
        return result;
    }

    public String toString() {
        return "ClientWindowActionPacket(windowId=" + this.getWindowId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", action=" + (Object)((Object)this.getAction()) + ", param=" + this.getParam() + ", carriedItem=" + this.getCarriedItem() + ", changedSlots=" + this.getChangedSlots() + ")";
    }

    public ClientWindowActionPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ClientWindowActionPacket(windowId, this.stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientWindowActionPacket(this.windowId, stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientWindowActionPacket(this.windowId, this.stateId, slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withAction(WindowAction action) {
        return this.action == action ? this : new ClientWindowActionPacket(this.windowId, this.stateId, this.slot, action, this.param, this.carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withParam(WindowActionParam param) {
        return this.param == param ? this : new ClientWindowActionPacket(this.windowId, this.stateId, this.slot, this.action, param, this.carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withCarriedItem(ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ClientWindowActionPacket(this.windowId, this.stateId, this.slot, this.action, this.param, carriedItem, this.changedSlots);
    }

    public ClientWindowActionPacket withChangedSlots(@NonNull Map<Integer, ItemStack> changedSlots) {
        if (changedSlots == null) {
            throw new NullPointerException("changedSlots is marked non-null but is null");
        }
        return this.changedSlots == changedSlots ? this : new ClientWindowActionPacket(this.windowId, this.stateId, this.slot, this.action, this.param, this.carriedItem, changedSlots);
    }

    private ClientWindowActionPacket() {
    }
}

