/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.window.UpdateStructureBlockAction;
import com.github.steveice10.mc.protocol.data.game.window.UpdateStructureBlockMode;
import com.github.steveice10.mc.protocol.data.game.world.block.StructureMirror;
import com.github.steveice10.mc.protocol.data.game.world.block.StructureRotation;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientUpdateStructureBlockPacket
implements Packet {
    private static final int FLAG_IGNORE_ENTITIES = 1;
    private static final int FLAG_SHOW_AIR = 2;
    private static final int FLAG_SHOW_BOUNDING_BOX = 4;
    @NonNull
    private Position position;
    @NonNull
    private UpdateStructureBlockAction action;
    @NonNull
    private UpdateStructureBlockMode mode;
    @NonNull
    private String name;
    @NonNull
    private Position offset;
    @NonNull
    private Position size;
    @NonNull
    private StructureMirror mirror;
    @NonNull
    private StructureRotation rotation;
    @NonNull
    private String metadata;
    private float integrity;
    private long seed;
    private boolean ignoreEntities;
    private boolean showAir;
    private boolean showBoundingBox;

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.action = MagicValues.key(UpdateStructureBlockAction.class, in.readVarInt());
        this.mode = MagicValues.key(UpdateStructureBlockMode.class, in.readVarInt());
        this.name = in.readString();
        this.offset = new Position(in.readByte(), in.readByte(), in.readByte());
        this.size = new Position(in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte());
        this.mirror = MagicValues.key(StructureMirror.class, in.readVarInt());
        this.rotation = MagicValues.key(StructureRotation.class, in.readVarInt());
        this.metadata = in.readString();
        this.integrity = in.readFloat();
        this.seed = in.readVarLong();
        int flags = in.readUnsignedByte();
        this.ignoreEntities = (flags & 1) != 0;
        this.showAir = (flags & 2) != 0;
        this.showBoundingBox = (flags & 4) != 0;
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.mode).intValue());
        out.writeString(this.name);
        out.writeByte(this.offset.getX());
        out.writeByte(this.offset.getY());
        out.writeByte(this.offset.getZ());
        out.writeByte(this.size.getX());
        out.writeByte(this.size.getY());
        out.writeByte(this.size.getZ());
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.mirror).intValue());
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.rotation).intValue());
        out.writeString(this.metadata);
        out.writeFloat(this.integrity);
        out.writeVarLong(this.seed);
        int flags = 0;
        if (this.ignoreEntities) {
            flags |= 1;
        }
        if (this.showAir) {
            flags |= 2;
        }
        if (this.showBoundingBox) {
            flags |= 4;
        }
        out.writeByte(flags);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public UpdateStructureBlockAction getAction() {
        return this.action;
    }

    @NonNull
    public UpdateStructureBlockMode getMode() {
        return this.mode;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Position getOffset() {
        return this.offset;
    }

    @NonNull
    public Position getSize() {
        return this.size;
    }

    @NonNull
    public StructureMirror getMirror() {
        return this.mirror;
    }

    @NonNull
    public StructureRotation getRotation() {
        return this.rotation;
    }

    @NonNull
    public String getMetadata() {
        return this.metadata;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isShowAir() {
        return this.showAir;
    }

    public boolean isShowBoundingBox() {
        return this.showBoundingBox;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientUpdateStructureBlockPacket)) {
            return false;
        }
        ClientUpdateStructureBlockPacket other = (ClientUpdateStructureBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIntegrity(), other.getIntegrity()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isIgnoreEntities() != other.isIgnoreEntities()) {
            return false;
        }
        if (this.isShowAir() != other.isShowAir()) {
            return false;
        }
        if (this.isShowBoundingBox() != other.isShowBoundingBox()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        UpdateStructureBlockAction this$action = this.getAction();
        UpdateStructureBlockAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        UpdateStructureBlockMode this$mode = this.getMode();
        UpdateStructureBlockMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Position this$offset = this.getOffset();
        Position other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Position this$size = this.getSize();
        Position other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        StructureMirror this$mirror = this.getMirror();
        StructureMirror other$mirror = other.getMirror();
        if (this$mirror == null ? other$mirror != null : !((Object)((Object)this$mirror)).equals((Object)other$mirror)) {
            return false;
        }
        StructureRotation this$rotation = this.getRotation();
        StructureRotation other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)((Object)this$rotation)).equals((Object)other$rotation)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientUpdateStructureBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIntegrity());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isIgnoreEntities() ? 79 : 97);
        result = result * 59 + (this.isShowAir() ? 79 : 97);
        result = result * 59 + (this.isShowBoundingBox() ? 79 : 97);
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        UpdateStructureBlockAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        UpdateStructureBlockMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Position $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Position $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        StructureMirror $mirror = this.getMirror();
        result = result * 59 + ($mirror == null ? 43 : ((Object)((Object)$mirror)).hashCode());
        StructureRotation $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)((Object)$rotation)).hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "ClientUpdateStructureBlockPacket(position=" + this.getPosition() + ", action=" + (Object)((Object)this.getAction()) + ", mode=" + (Object)((Object)this.getMode()) + ", name=" + this.getName() + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ", mirror=" + (Object)((Object)this.getMirror()) + ", rotation=" + (Object)((Object)this.getRotation()) + ", metadata=" + this.getMetadata() + ", integrity=" + this.getIntegrity() + ", seed=" + this.getSeed() + ", ignoreEntities=" + this.isIgnoreEntities() + ", showAir=" + this.isShowAir() + ", showBoundingBox=" + this.isShowBoundingBox() + ")";
    }

    public ClientUpdateStructureBlockPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientUpdateStructureBlockPacket(position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withAction(@NonNull UpdateStructureBlockAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientUpdateStructureBlockPacket(this.position, action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withMode(@NonNull UpdateStructureBlockMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.mode == mode ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withOffset(@NonNull Position offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        return this.offset == offset ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withSize(@NonNull Position size) {
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        return this.size == size ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withMirror(@NonNull StructureMirror mirror) {
        if (mirror == null) {
            throw new NullPointerException("mirror is marked non-null but is null");
        }
        return this.mirror == mirror ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withRotation(@NonNull StructureRotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        return this.rotation == rotation ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withMetadata(@NonNull String metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata == metadata ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withIntegrity(float integrity) {
        return this.integrity == integrity ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withSeed(long seed) {
        return this.seed == seed ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, seed, this.ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withIgnoreEntities(boolean ignoreEntities) {
        return this.ignoreEntities == ignoreEntities ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, ignoreEntities, this.showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withShowAir(boolean showAir) {
        return this.showAir == showAir ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, showAir, this.showBoundingBox);
    }

    public ClientUpdateStructureBlockPacket withShowBoundingBox(boolean showBoundingBox) {
        return this.showBoundingBox == showBoundingBox ? this : new ClientUpdateStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, showBoundingBox);
    }

    private ClientUpdateStructureBlockPacket() {
    }

    public ClientUpdateStructureBlockPacket(@NonNull Position position, @NonNull UpdateStructureBlockAction action, @NonNull UpdateStructureBlockMode mode, @NonNull String name, @NonNull Position offset, @NonNull Position size, @NonNull StructureMirror mirror, @NonNull StructureRotation rotation, @NonNull String metadata, float integrity, long seed, boolean ignoreEntities, boolean showAir, boolean showBoundingBox) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror is marked non-null but is null");
        }
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.position = position;
        this.action = action;
        this.mode = mode;
        this.name = name;
        this.offset = offset;
        this.size = size;
        this.mirror = mirror;
        this.rotation = rotation;
        this.metadata = metadata;
        this.integrity = integrity;
        this.seed = seed;
        this.ignoreEntities = ignoreEntities;
        this.showAir = showAir;
        this.showBoundingBox = showBoundingBox;
    }
}

