/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.world.block.CommandBlockMode;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientUpdateCommandBlockPacket
implements Packet {
    private static final int FLAG_TRACK_OUTPUT = 1;
    private static final int FLAG_CONDITIONAL = 2;
    private static final int FLAG_AUTOMATIC = 4;
    @NonNull
    private Position position;
    @NonNull
    private String command;
    @NonNull
    private CommandBlockMode mode;
    private boolean doesTrackOutput;
    private boolean conditional;
    private boolean automatic;

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.command = in.readString();
        this.mode = MagicValues.key(CommandBlockMode.class, in.readVarInt());
        int flags = in.readUnsignedByte();
        this.doesTrackOutput = (flags & 1) != 0;
        this.conditional = (flags & 2) != 0;
        this.automatic = (flags & 4) != 0;
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeString(this.command);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.mode).intValue());
        int flags = 0;
        if (this.doesTrackOutput) {
            flags |= 1;
        }
        if (this.conditional) {
            flags |= 2;
        }
        if (this.automatic) {
            flags |= 4;
        }
        out.writeByte(flags);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public String getCommand() {
        return this.command;
    }

    @NonNull
    public CommandBlockMode getMode() {
        return this.mode;
    }

    public boolean isDoesTrackOutput() {
        return this.doesTrackOutput;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientUpdateCommandBlockPacket)) {
            return false;
        }
        ClientUpdateCommandBlockPacket other = (ClientUpdateCommandBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDoesTrackOutput() != other.isDoesTrackOutput()) {
            return false;
        }
        if (this.isConditional() != other.isConditional()) {
            return false;
        }
        if (this.isAutomatic() != other.isAutomatic()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        CommandBlockMode this$mode = this.getMode();
        CommandBlockMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientUpdateCommandBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDoesTrackOutput() ? 79 : 97);
        result = result * 59 + (this.isConditional() ? 79 : 97);
        result = result * 59 + (this.isAutomatic() ? 79 : 97);
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        CommandBlockMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientUpdateCommandBlockPacket(position=" + this.getPosition() + ", command=" + this.getCommand() + ", mode=" + (Object)((Object)this.getMode()) + ", doesTrackOutput=" + this.isDoesTrackOutput() + ", conditional=" + this.isConditional() + ", automatic=" + this.isAutomatic() + ")";
    }

    public ClientUpdateCommandBlockPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientUpdateCommandBlockPacket(position, this.command, this.mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public ClientUpdateCommandBlockPacket withCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.command == command ? this : new ClientUpdateCommandBlockPacket(this.position, command, this.mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public ClientUpdateCommandBlockPacket withMode(@NonNull CommandBlockMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.mode == mode ? this : new ClientUpdateCommandBlockPacket(this.position, this.command, mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public ClientUpdateCommandBlockPacket withDoesTrackOutput(boolean doesTrackOutput) {
        return this.doesTrackOutput == doesTrackOutput ? this : new ClientUpdateCommandBlockPacket(this.position, this.command, this.mode, doesTrackOutput, this.conditional, this.automatic);
    }

    public ClientUpdateCommandBlockPacket withConditional(boolean conditional) {
        return this.conditional == conditional ? this : new ClientUpdateCommandBlockPacket(this.position, this.command, this.mode, this.doesTrackOutput, conditional, this.automatic);
    }

    public ClientUpdateCommandBlockPacket withAutomatic(boolean automatic) {
        return this.automatic == automatic ? this : new ClientUpdateCommandBlockPacket(this.position, this.command, this.mode, this.doesTrackOutput, this.conditional, automatic);
    }

    private ClientUpdateCommandBlockPacket() {
    }

    public ClientUpdateCommandBlockPacket(@NonNull Position position, @NonNull String command, @NonNull CommandBlockMode mode, boolean doesTrackOutput, boolean conditional, boolean automatic) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.position = position;
        this.command = command;
        this.mode = mode;
        this.doesTrackOutput = doesTrackOutput;
        this.conditional = conditional;
        this.automatic = automatic;
    }
}

