/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientPrepareCraftingGridPacket
implements Packet {
    private int windowId;
    @NonNull
    private String recipeId;
    private boolean makeAll;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readByte();
        this.recipeId = in.readString();
        this.makeAll = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeString(this.recipeId);
        out.writeBoolean(this.makeAll);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    @NonNull
    public String getRecipeId() {
        return this.recipeId;
    }

    public boolean isMakeAll() {
        return this.makeAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPrepareCraftingGridPacket)) {
            return false;
        }
        ClientPrepareCraftingGridPacket other = (ClientPrepareCraftingGridPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.isMakeAll() != other.isMakeAll()) {
            return false;
        }
        String this$recipeId = this.getRecipeId();
        String other$recipeId = other.getRecipeId();
        return !(this$recipeId == null ? other$recipeId != null : !this$recipeId.equals(other$recipeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPrepareCraftingGridPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + (this.isMakeAll() ? 79 : 97);
        String $recipeId = this.getRecipeId();
        result = result * 59 + ($recipeId == null ? 43 : $recipeId.hashCode());
        return result;
    }

    public String toString() {
        return "ClientPrepareCraftingGridPacket(windowId=" + this.getWindowId() + ", recipeId=" + this.getRecipeId() + ", makeAll=" + this.isMakeAll() + ")";
    }

    public ClientPrepareCraftingGridPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ClientPrepareCraftingGridPacket(windowId, this.recipeId, this.makeAll);
    }

    public ClientPrepareCraftingGridPacket withRecipeId(@NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        return this.recipeId == recipeId ? this : new ClientPrepareCraftingGridPacket(this.windowId, recipeId, this.makeAll);
    }

    public ClientPrepareCraftingGridPacket withMakeAll(boolean makeAll) {
        return this.makeAll == makeAll ? this : new ClientPrepareCraftingGridPacket(this.windowId, this.recipeId, makeAll);
    }

    private ClientPrepareCraftingGridPacket() {
    }

    public ClientPrepareCraftingGridPacket(int windowId, @NonNull String recipeId, boolean makeAll) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        this.windowId = windowId;
        this.recipeId = recipeId;
        this.makeAll = makeAll;
    }
}

