/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientCreativeInventoryActionPacket
implements Packet {
    private int slot;
    @NonNull
    private ItemStack clickedItem;

    public void read(NetInput in) throws IOException {
        this.slot = in.readShort();
        this.clickedItem = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeShort(this.slot);
        ItemStack.write(out, this.clickedItem);
    }

    public boolean isPriority() {
        return false;
    }

    public int getSlot() {
        return this.slot;
    }

    @NonNull
    public ItemStack getClickedItem() {
        return this.clickedItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCreativeInventoryActionPacket)) {
            return false;
        }
        ClientCreativeInventoryActionPacket other = (ClientCreativeInventoryActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$clickedItem = this.getClickedItem();
        ItemStack other$clickedItem = other.getClickedItem();
        return !(this$clickedItem == null ? other$clickedItem != null : !((Object)this$clickedItem).equals(other$clickedItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientCreativeInventoryActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        ItemStack $clickedItem = this.getClickedItem();
        result = result * 59 + ($clickedItem == null ? 43 : ((Object)$clickedItem).hashCode());
        return result;
    }

    public String toString() {
        return "ClientCreativeInventoryActionPacket(slot=" + this.getSlot() + ", clickedItem=" + this.getClickedItem() + ")";
    }

    public ClientCreativeInventoryActionPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientCreativeInventoryActionPacket(slot, this.clickedItem);
    }

    public ClientCreativeInventoryActionPacket withClickedItem(@NonNull ItemStack clickedItem) {
        if (clickedItem == null) {
            throw new NullPointerException("clickedItem is marked non-null but is null");
        }
        return this.clickedItem == clickedItem ? this : new ClientCreativeInventoryActionPacket(this.slot, clickedItem);
    }

    private ClientCreativeInventoryActionPacket() {
    }

    public ClientCreativeInventoryActionPacket(int slot, @NonNull ItemStack clickedItem) {
        if (clickedItem == null) {
            throw new NullPointerException("clickedItem is marked non-null but is null");
        }
        this.slot = slot;
        this.clickedItem = clickedItem;
    }
}

