/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.window.CraftingBookStateType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientCraftingBookStatePacket
implements Packet {
    @NonNull
    private CraftingBookStateType type;
    private boolean bookOpen;
    private boolean filterActive;

    public void read(NetInput in) throws IOException {
        this.type = MagicValues.key(CraftingBookStateType.class, in.readVarInt());
        this.bookOpen = in.readBoolean();
        this.filterActive = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeBoolean(this.bookOpen);
        out.writeBoolean(this.filterActive);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public CraftingBookStateType getType() {
        return this.type;
    }

    public boolean isBookOpen() {
        return this.bookOpen;
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCraftingBookStatePacket)) {
            return false;
        }
        ClientCraftingBookStatePacket other = (ClientCraftingBookStatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBookOpen() != other.isBookOpen()) {
            return false;
        }
        if (this.isFilterActive() != other.isFilterActive()) {
            return false;
        }
        CraftingBookStateType this$type = this.getType();
        CraftingBookStateType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientCraftingBookStatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBookOpen() ? 79 : 97);
        result = result * 59 + (this.isFilterActive() ? 79 : 97);
        CraftingBookStateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientCraftingBookStatePacket(type=" + (Object)((Object)this.getType()) + ", bookOpen=" + this.isBookOpen() + ", filterActive=" + this.isFilterActive() + ")";
    }

    public ClientCraftingBookStatePacket withType(@NonNull CraftingBookStateType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientCraftingBookStatePacket(type, this.bookOpen, this.filterActive);
    }

    public ClientCraftingBookStatePacket withBookOpen(boolean bookOpen) {
        return this.bookOpen == bookOpen ? this : new ClientCraftingBookStatePacket(this.type, bookOpen, this.filterActive);
    }

    public ClientCraftingBookStatePacket withFilterActive(boolean filterActive) {
        return this.filterActive == filterActive ? this : new ClientCraftingBookStatePacket(this.type, this.bookOpen, filterActive);
    }

    private ClientCraftingBookStatePacket() {
    }

    public ClientCraftingBookStatePacket(@NonNull CraftingBookStateType type, boolean bookOpen, boolean filterActive) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.bookOpen = bookOpen;
        this.filterActive = filterActive;
    }
}

