/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientClickWindowButtonPacket
implements Packet {
    private int windowId;
    private int buttonId;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readByte();
        this.buttonId = in.readByte();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeByte(this.buttonId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getButtonId() {
        return this.buttonId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientClickWindowButtonPacket)) {
            return false;
        }
        ClientClickWindowButtonPacket other = (ClientClickWindowButtonPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        return this.getButtonId() == other.getButtonId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientClickWindowButtonPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getButtonId();
        return result;
    }

    public String toString() {
        return "ClientClickWindowButtonPacket(windowId=" + this.getWindowId() + ", buttonId=" + this.getButtonId() + ")";
    }

    public ClientClickWindowButtonPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ClientClickWindowButtonPacket(windowId, this.buttonId);
    }

    public ClientClickWindowButtonPacket withButtonId(int buttonId) {
        return this.buttonId == buttonId ? this : new ClientClickWindowButtonPacket(this.windowId, buttonId);
    }

    private ClientClickWindowButtonPacket() {
    }

    public ClientClickWindowButtonPacket(int windowId, int buttonId) {
        this.windowId = windowId;
        this.buttonId = buttonId;
    }
}

