/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.window.AdvancementTabAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientAdvancementTabPacket
implements Packet {
    @NonNull
    private AdvancementTabAction action;
    private String tabId;

    public ClientAdvancementTabPacket() {
        this.action = AdvancementTabAction.CLOSED_SCREEN;
    }

    public ClientAdvancementTabPacket(@NonNull String tabId) {
        if (tabId == null) {
            throw new NullPointerException("tabId is marked non-null but is null");
        }
        this.action = AdvancementTabAction.OPENED_TAB;
        this.tabId = tabId;
    }

    public String getTabId() {
        if (this.action != AdvancementTabAction.OPENED_TAB) {
            throw new IllegalStateException("tabId is only set if action is " + (Object)((Object)AdvancementTabAction.OPENED_TAB) + " but it was " + (Object)((Object)this.action));
        }
        return this.tabId;
    }

    public void read(NetInput in) throws IOException {
        this.action = MagicValues.key(AdvancementTabAction.class, in.readVarInt());
        switch (this.action) {
            case CLOSED_SCREEN: {
                break;
            }
            case OPENED_TAB: {
                this.tabId = in.readString();
                break;
            }
            default: {
                throw new IOException("Unknown advancement tab action: " + (Object)((Object)this.action));
            }
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        switch (this.action) {
            case CLOSED_SCREEN: {
                break;
            }
            case OPENED_TAB: {
                out.writeString(this.tabId);
                break;
            }
            default: {
                throw new IOException("Unknown advancement tab action: " + (Object)((Object)this.action));
            }
        }
    }

    public boolean isPriority() {
        return false;
    }

    public String toString() {
        return "ClientAdvancementTabPacket(action=" + (Object)((Object)this.getAction()) + ", tabId=" + this.getTabId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientAdvancementTabPacket)) {
            return false;
        }
        ClientAdvancementTabPacket other = (ClientAdvancementTabPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdvancementTabAction this$action = this.getAction();
        AdvancementTabAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$tabId = this.getTabId();
        String other$tabId = other.getTabId();
        return !(this$tabId == null ? other$tabId != null : !this$tabId.equals(other$tabId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientAdvancementTabPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdvancementTabAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $tabId = this.getTabId();
        result = result * 59 + ($tabId == null ? 43 : $tabId.hashCode());
        return result;
    }

    @NonNull
    public AdvancementTabAction getAction() {
        return this.action;
    }
}

