/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerState;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientPlayerStatePacket
implements Packet {
    private int entityId;
    @NonNull
    private PlayerState state;
    private int jumpBoost;

    public ClientPlayerStatePacket(int entityId, PlayerState state) {
        this(entityId, state, 0);
    }

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.state = MagicValues.key(PlayerState.class, in.readVarInt());
        this.jumpBoost = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.state).intValue());
        out.writeVarInt(this.jumpBoost);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public PlayerState getState() {
        return this.state;
    }

    public int getJumpBoost() {
        return this.jumpBoost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerStatePacket)) {
            return false;
        }
        ClientPlayerStatePacket other = (ClientPlayerStatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getJumpBoost() != other.getJumpBoost()) {
            return false;
        }
        PlayerState this$state = this.getState();
        PlayerState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerStatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getJumpBoost();
        PlayerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientPlayerStatePacket(entityId=" + this.getEntityId() + ", state=" + (Object)((Object)this.getState()) + ", jumpBoost=" + this.getJumpBoost() + ")";
    }

    public ClientPlayerStatePacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientPlayerStatePacket(entityId, this.state, this.jumpBoost);
    }

    public ClientPlayerStatePacket withState(@NonNull PlayerState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return this.state == state ? this : new ClientPlayerStatePacket(this.entityId, state, this.jumpBoost);
    }

    public ClientPlayerStatePacket withJumpBoost(int jumpBoost) {
        return this.jumpBoost == jumpBoost ? this : new ClientPlayerStatePacket(this.entityId, this.state, jumpBoost);
    }

    private ClientPlayerStatePacket() {
    }

    public ClientPlayerStatePacket(int entityId, @NonNull PlayerState state, int jumpBoost) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.entityId = entityId;
        this.state = state;
        this.jumpBoost = jumpBoost;
    }
}

