/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientPlayerPositionPacket
implements Packet {
    private boolean onGround;
    private double x;
    private double y;
    private double z;

    public void read(NetInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.onGround = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeBoolean(this.onGround);
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerPositionPacket)) {
            return false;
        }
        ClientPlayerPositionPacket other = (ClientPlayerPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), other.getZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        return result;
    }

    public String toString() {
        return "ClientPlayerPositionPacket(onGround=" + this.isOnGround() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    public ClientPlayerPositionPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ClientPlayerPositionPacket(onGround, this.x, this.y, this.z);
    }

    public ClientPlayerPositionPacket withX(double x) {
        return this.x == x ? this : new ClientPlayerPositionPacket(this.onGround, x, this.y, this.z);
    }

    public ClientPlayerPositionPacket withY(double y) {
        return this.y == y ? this : new ClientPlayerPositionPacket(this.onGround, this.x, y, this.z);
    }

    public ClientPlayerPositionPacket withZ(double z) {
        return this.z == z ? this : new ClientPlayerPositionPacket(this.onGround, this.x, this.y, z);
    }

    private ClientPlayerPositionPacket() {
    }

    public ClientPlayerPositionPacket(boolean onGround, double x, double y, double z) {
        this.onGround = onGround;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

