/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.world.block.BlockFace;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientPlayerPlaceBlockPacket
implements Packet {
    @NonNull
    private Position position;
    @NonNull
    private BlockFace face;
    @NonNull
    private Hand hand;
    private float cursorX;
    private float cursorY;
    private float cursorZ;
    private boolean insideBlock;

    public void read(NetInput in) throws IOException {
        this.hand = MagicValues.key(Hand.class, in.readVarInt());
        this.position = Position.read(in);
        this.face = MagicValues.key(BlockFace.class, in.readVarInt());
        this.cursorX = in.readFloat();
        this.cursorY = in.readFloat();
        this.cursorZ = in.readFloat();
        this.insideBlock = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.hand).intValue());
        Position.write(out, this.position);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.face).intValue());
        out.writeFloat(this.cursorX);
        out.writeFloat(this.cursorY);
        out.writeFloat(this.cursorZ);
        out.writeBoolean(this.insideBlock);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public BlockFace getFace() {
        return this.face;
    }

    @NonNull
    public Hand getHand() {
        return this.hand;
    }

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public float getCursorZ() {
        return this.cursorZ;
    }

    public boolean isInsideBlock() {
        return this.insideBlock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerPlaceBlockPacket)) {
            return false;
        }
        ClientPlayerPlaceBlockPacket other = (ClientPlayerPlaceBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getCursorX(), other.getCursorX()) != 0) {
            return false;
        }
        if (Float.compare(this.getCursorY(), other.getCursorY()) != 0) {
            return false;
        }
        if (Float.compare(this.getCursorZ(), other.getCursorZ()) != 0) {
            return false;
        }
        if (this.isInsideBlock() != other.isInsideBlock()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockFace this$face = this.getFace();
        BlockFace other$face = other.getFace();
        if (this$face == null ? other$face != null : !((Object)((Object)this$face)).equals((Object)other$face)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerPlaceBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getCursorX());
        result = result * 59 + Float.floatToIntBits(this.getCursorY());
        result = result * 59 + Float.floatToIntBits(this.getCursorZ());
        result = result * 59 + (this.isInsideBlock() ? 79 : 97);
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockFace $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : ((Object)((Object)$face)).hashCode());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientPlayerPlaceBlockPacket(position=" + this.getPosition() + ", face=" + (Object)((Object)this.getFace()) + ", hand=" + (Object)((Object)this.getHand()) + ", cursorX=" + this.getCursorX() + ", cursorY=" + this.getCursorY() + ", cursorZ=" + this.getCursorZ() + ", insideBlock=" + this.isInsideBlock() + ")";
    }

    public ClientPlayerPlaceBlockPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientPlayerPlaceBlockPacket(position, this.face, this.hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withFace(@NonNull BlockFace face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ClientPlayerPlaceBlockPacket(this.position, face, this.hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withHand(@NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ClientPlayerPlaceBlockPacket(this.position, this.face, hand, this.cursorX, this.cursorY, this.cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withCursorX(float cursorX) {
        return this.cursorX == cursorX ? this : new ClientPlayerPlaceBlockPacket(this.position, this.face, this.hand, cursorX, this.cursorY, this.cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withCursorY(float cursorY) {
        return this.cursorY == cursorY ? this : new ClientPlayerPlaceBlockPacket(this.position, this.face, this.hand, this.cursorX, cursorY, this.cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withCursorZ(float cursorZ) {
        return this.cursorZ == cursorZ ? this : new ClientPlayerPlaceBlockPacket(this.position, this.face, this.hand, this.cursorX, this.cursorY, cursorZ, this.insideBlock);
    }

    public ClientPlayerPlaceBlockPacket withInsideBlock(boolean insideBlock) {
        return this.insideBlock == insideBlock ? this : new ClientPlayerPlaceBlockPacket(this.position, this.face, this.hand, this.cursorX, this.cursorY, this.cursorZ, insideBlock);
    }

    private ClientPlayerPlaceBlockPacket() {
    }

    public ClientPlayerPlaceBlockPacket(@NonNull Position position, @NonNull BlockFace face, @NonNull Hand hand, float cursorX, float cursorY, float cursorZ, boolean insideBlock) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.position = position;
        this.face = face;
        this.hand = hand;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.cursorZ = cursorZ;
        this.insideBlock = insideBlock;
    }
}

