/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.InteractAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientPlayerInteractEntityPacket
implements Packet {
    private int entityId;
    @NonNull
    private InteractAction action;
    private float targetX;
    private float targetY;
    private float targetZ;
    @NonNull
    private Hand hand;
    private boolean isSneaking;

    public ClientPlayerInteractEntityPacket(int entityId, InteractAction action, boolean isSneaking) {
        this(entityId, action, Hand.MAIN_HAND, isSneaking);
    }

    public ClientPlayerInteractEntityPacket(int entityId, InteractAction action, Hand hand, boolean isSneaking) {
        this(entityId, action, 0.0f, 0.0f, 0.0f, hand, isSneaking);
    }

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.action = MagicValues.key(InteractAction.class, in.readVarInt());
        if (this.action == InteractAction.INTERACT_AT) {
            this.targetX = in.readFloat();
            this.targetY = in.readFloat();
            this.targetZ = in.readFloat();
        }
        if (this.action == InteractAction.INTERACT || this.action == InteractAction.INTERACT_AT) {
            this.hand = MagicValues.key(Hand.class, in.readVarInt());
        }
        this.isSneaking = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == InteractAction.INTERACT_AT) {
            out.writeFloat(this.targetX);
            out.writeFloat(this.targetY);
            out.writeFloat(this.targetZ);
        }
        if (this.action == InteractAction.INTERACT || this.action == InteractAction.INTERACT_AT) {
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.hand).intValue());
        }
        out.writeBoolean(this.isSneaking);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public InteractAction getAction() {
        return this.action;
    }

    public float getTargetX() {
        return this.targetX;
    }

    public float getTargetY() {
        return this.targetY;
    }

    public float getTargetZ() {
        return this.targetZ;
    }

    @NonNull
    public Hand getHand() {
        return this.hand;
    }

    public boolean isSneaking() {
        return this.isSneaking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerInteractEntityPacket)) {
            return false;
        }
        ClientPlayerInteractEntityPacket other = (ClientPlayerInteractEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Float.compare(this.getTargetX(), other.getTargetX()) != 0) {
            return false;
        }
        if (Float.compare(this.getTargetY(), other.getTargetY()) != 0) {
            return false;
        }
        if (Float.compare(this.getTargetZ(), other.getTargetZ()) != 0) {
            return false;
        }
        if (this.isSneaking() != other.isSneaking()) {
            return false;
        }
        InteractAction this$action = this.getAction();
        InteractAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerInteractEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getTargetX());
        result = result * 59 + Float.floatToIntBits(this.getTargetY());
        result = result * 59 + Float.floatToIntBits(this.getTargetZ());
        result = result * 59 + (this.isSneaking() ? 79 : 97);
        InteractAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientPlayerInteractEntityPacket(entityId=" + this.getEntityId() + ", action=" + (Object)((Object)this.getAction()) + ", targetX=" + this.getTargetX() + ", targetY=" + this.getTargetY() + ", targetZ=" + this.getTargetZ() + ", hand=" + (Object)((Object)this.getHand()) + ", isSneaking=" + this.isSneaking() + ")";
    }

    public ClientPlayerInteractEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientPlayerInteractEntityPacket(entityId, this.action, this.targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withAction(@NonNull InteractAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientPlayerInteractEntityPacket(this.entityId, action, this.targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withTargetX(float targetX) {
        return this.targetX == targetX ? this : new ClientPlayerInteractEntityPacket(this.entityId, this.action, targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withTargetY(float targetY) {
        return this.targetY == targetY ? this : new ClientPlayerInteractEntityPacket(this.entityId, this.action, this.targetX, targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withTargetZ(float targetZ) {
        return this.targetZ == targetZ ? this : new ClientPlayerInteractEntityPacket(this.entityId, this.action, this.targetX, this.targetY, targetZ, this.hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withHand(@NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ClientPlayerInteractEntityPacket(this.entityId, this.action, this.targetX, this.targetY, this.targetZ, hand, this.isSneaking);
    }

    public ClientPlayerInteractEntityPacket withSneaking(boolean isSneaking) {
        return this.isSneaking == isSneaking ? this : new ClientPlayerInteractEntityPacket(this.entityId, this.action, this.targetX, this.targetY, this.targetZ, this.hand, isSneaking);
    }

    private ClientPlayerInteractEntityPacket() {
    }

    public ClientPlayerInteractEntityPacket(int entityId, @NonNull InteractAction action, float targetX, float targetY, float targetZ, @NonNull Hand hand, boolean isSneaking) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.entityId = entityId;
        this.action = action;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.hand = hand;
        this.isSneaking = isSneaking;
    }
}

