/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.mc.protocol.data.game.world.block.BlockFace;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientPlayerActionPacket
implements Packet {
    @NonNull
    private PlayerAction action;
    @NonNull
    private Position position;
    @NonNull
    private BlockFace face;

    public void read(NetInput in) throws IOException {
        this.action = MagicValues.key(PlayerAction.class, in.readVarInt());
        this.position = Position.read(in);
        this.face = MagicValues.key(BlockFace.class, in.readUnsignedByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        Position.write(out, this.position);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.face).intValue());
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public PlayerAction getAction() {
        return this.action;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public BlockFace getFace() {
        return this.face;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerActionPacket)) {
            return false;
        }
        ClientPlayerActionPacket other = (ClientPlayerActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerAction this$action = this.getAction();
        PlayerAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockFace this$face = this.getFace();
        BlockFace other$face = other.getFace();
        return !(this$face == null ? other$face != null : !((Object)((Object)this$face)).equals((Object)other$face));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockFace $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : ((Object)((Object)$face)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientPlayerActionPacket(action=" + (Object)((Object)this.getAction()) + ", position=" + this.getPosition() + ", face=" + (Object)((Object)this.getFace()) + ")";
    }

    public ClientPlayerActionPacket withAction(@NonNull PlayerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientPlayerActionPacket(action, this.position, this.face);
    }

    public ClientPlayerActionPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientPlayerActionPacket(this.action, position, this.face);
    }

    public ClientPlayerActionPacket withFace(@NonNull BlockFace face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ClientPlayerActionPacket(this.action, this.position, face);
    }

    private ClientPlayerActionPacket() {
    }

    public ClientPlayerActionPacket(@NonNull PlayerAction action, @NonNull Position position, @NonNull BlockFace face) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        this.action = action;
        this.position = position;
        this.face = face;
    }
}

