/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientPlayerAbilitiesPacket
implements Packet {
    private static final int FLAG_FLYING = 2;
    private boolean flying;

    public void read(NetInput in) throws IOException {
        byte flags = in.readByte();
        this.flying = (flags & 2) > 0;
    }

    public void write(NetOutput out) throws IOException {
        int flags = 0;
        if (this.flying) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientPlayerAbilitiesPacket)) {
            return false;
        }
        ClientPlayerAbilitiesPacket other = (ClientPlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isFlying() == other.isFlying();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientPlayerAbilitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlying() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClientPlayerAbilitiesPacket(flying=" + this.isFlying() + ")";
    }

    public ClientPlayerAbilitiesPacket withFlying(boolean flying) {
        return this.flying == flying ? this : new ClientPlayerAbilitiesPacket(flying);
    }

    private ClientPlayerAbilitiesPacket() {
    }

    public ClientPlayerAbilitiesPacket(boolean flying) {
        this.flying = flying;
    }
}

