/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.client;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientTabCompletePacket
implements Packet {
    private int transactionId;
    @NonNull
    private String text;

    public void read(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.text = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        out.writeString(this.text);
    }

    public boolean isPriority() {
        return false;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientTabCompletePacket)) {
            return false;
        }
        ClientTabCompletePacket other = (ClientTabCompletePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientTabCompletePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "ClientTabCompletePacket(transactionId=" + this.getTransactionId() + ", text=" + this.getText() + ")";
    }

    public ClientTabCompletePacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientTabCompletePacket(transactionId, this.text);
    }

    public ClientTabCompletePacket withText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.text == text ? this : new ClientTabCompletePacket(this.transactionId, text);
    }

    private ClientTabCompletePacket() {
    }

    public ClientTabCompletePacket(int transactionId, @NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.text = text;
    }
}

