/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.handshake.client;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.handshake.HandshakeIntent;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class HandshakePacket
implements Packet {
    private int protocolVersion;
    @NonNull
    private String hostname;
    private int port;
    @NonNull
    private HandshakeIntent intent;

    public void read(NetInput in) throws IOException {
        this.protocolVersion = in.readVarInt();
        this.hostname = in.readString();
        this.port = in.readUnsignedShort();
        this.intent = MagicValues.key(HandshakeIntent.class, in.readVarInt());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.protocolVersion);
        out.writeString(this.hostname);
        out.writeShort(this.port);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.intent).intValue());
    }

    public boolean isPriority() {
        return true;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public HandshakeIntent getIntent() {
        return this.intent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandshakePacket)) {
            return false;
        }
        HandshakePacket other = (HandshakePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        HandshakeIntent this$intent = this.getIntent();
        HandshakeIntent other$intent = other.getIntent();
        return !(this$intent == null ? other$intent != null : !((Object)((Object)this$intent)).equals((Object)other$intent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandshakePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProtocolVersion();
        result = result * 59 + this.getPort();
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        HandshakeIntent $intent = this.getIntent();
        result = result * 59 + ($intent == null ? 43 : ((Object)((Object)$intent)).hashCode());
        return result;
    }

    public String toString() {
        return "HandshakePacket(protocolVersion=" + this.getProtocolVersion() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", intent=" + (Object)((Object)this.getIntent()) + ")";
    }

    public HandshakePacket withProtocolVersion(int protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new HandshakePacket(protocolVersion, this.hostname, this.port, this.intent);
    }

    public HandshakePacket withHostname(@NonNull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        return this.hostname == hostname ? this : new HandshakePacket(this.protocolVersion, hostname, this.port, this.intent);
    }

    public HandshakePacket withPort(int port) {
        return this.port == port ? this : new HandshakePacket(this.protocolVersion, this.hostname, port, this.intent);
    }

    public HandshakePacket withIntent(@NonNull HandshakeIntent intent) {
        if (intent == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        return this.intent == intent ? this : new HandshakePacket(this.protocolVersion, this.hostname, this.port, intent);
    }

    private HandshakePacket() {
    }

    public HandshakePacket(int protocolVersion, @NonNull String hostname, int port, @NonNull HandshakeIntent intent) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        if (intent == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        this.protocolVersion = protocolVersion;
        this.hostname = hostname;
        this.port = port;
        this.intent = intent;
    }
}

