/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.world.notify;

import com.github.steveice10.mc.protocol.data.game.world.notify.ClientNotificationValue;

public class ThunderStrengthValue
implements ClientNotificationValue {
    private final float strength;

    public ThunderStrengthValue(float strength) {
        if (strength > 1.0f) {
            strength = 1.0f;
        }
        if (strength < 0.0f) {
            strength = 0.0f;
        }
        this.strength = strength;
    }

    public float getStrength() {
        return this.strength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThunderStrengthValue)) {
            return false;
        }
        ThunderStrengthValue other = (ThunderStrengthValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getStrength(), other.getStrength()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThunderStrengthValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getStrength());
        return result;
    }

    public String toString() {
        return "ThunderStrengthValue(strength=" + this.getStrength() + ")";
    }
}

