/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Rotation;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.VillagerData;
import com.github.steveice10.mc.protocol.data.game.world.block.BlockFace;
import com.github.steveice10.mc.protocol.data.game.world.particle.Particle;
import com.github.steveice10.mc.protocol.data.game.world.particle.ParticleData;
import com.github.steveice10.mc.protocol.data.game.world.particle.ParticleType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class EntityMetadata {
    private final int id;
    @NonNull
    private final MetadataType type;
    private final Object value;

    public static EntityMetadata[] read(NetInput in) throws IOException {
        int id;
        ArrayList<EntityMetadata> ret = new ArrayList<EntityMetadata>();
        while ((id = in.readUnsignedByte()) != 255) {
            int typeId = in.readVarInt();
            MetadataType type = MagicValues.key(MetadataType.class, typeId);
            Object value = null;
            switch (type) {
                case BYTE: {
                    value = in.readByte();
                    break;
                }
                case INT: 
                case BLOCK_STATE: {
                    value = in.readVarInt();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(in.readFloat());
                    break;
                }
                case STRING: {
                    value = in.readString();
                    break;
                }
                case OPTIONAL_CHAT: {
                    boolean chatPresent = in.readBoolean();
                    if (!chatPresent) break;
                }
                case CHAT: {
                    value = DefaultComponentSerializer.get().deserialize((Object)in.readString());
                    break;
                }
                case ITEM: {
                    value = ItemStack.read(in);
                    break;
                }
                case BOOLEAN: {
                    value = in.readBoolean();
                    break;
                }
                case ROTATION: {
                    value = Rotation.read(in);
                    break;
                }
                case OPTIONAL_POSITION: {
                    boolean positionPresent = in.readBoolean();
                    if (!positionPresent) break;
                }
                case POSITION: {
                    value = Position.read(in);
                    break;
                }
                case BLOCK_FACE: {
                    value = MagicValues.key(BlockFace.class, in.readVarInt());
                    break;
                }
                case OPTIONAL_UUID: {
                    boolean uuidPresent = in.readBoolean();
                    if (!uuidPresent) break;
                    value = in.readUUID();
                    break;
                }
                case NBT_TAG: {
                    value = NBT.read(in);
                    break;
                }
                case PARTICLE: {
                    ParticleType particleType = ParticleType.values()[in.readVarInt()];
                    value = new Particle(particleType, ParticleData.read(in, particleType));
                    break;
                }
                case VILLAGER_DATA: {
                    value = new VillagerData(in.readVarInt(), in.readVarInt(), in.readVarInt());
                    break;
                }
                case OPTIONAL_VARINT: {
                    int i = in.readVarInt();
                    value = i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
                    break;
                }
                case POSE: {
                    value = MagicValues.key(Pose.class, in.readVarInt());
                    break;
                }
                default: {
                    throw new IOException("Unknown metadata type id: " + typeId);
                }
            }
            ret.add(new EntityMetadata(id, type, value));
        }
        return ret.toArray(new EntityMetadata[ret.size()]);
    }

    public static void write(NetOutput out, EntityMetadata[] metadata) throws IOException {
        block21: for (EntityMetadata meta : metadata) {
            out.writeByte(meta.getId());
            out.writeVarInt(MagicValues.value(Integer.class, (Object)meta.getType()).intValue());
            switch (meta.getType()) {
                case BYTE: {
                    out.writeByte((int)((Byte)meta.getValue()).byteValue());
                    continue block21;
                }
                case INT: {
                    out.writeVarInt(((Integer)meta.getValue()).intValue());
                    continue block21;
                }
                case FLOAT: {
                    out.writeFloat(((Float)meta.getValue()).floatValue());
                    continue block21;
                }
                case STRING: {
                    out.writeString((String)meta.getValue());
                    continue block21;
                }
                case OPTIONAL_CHAT: {
                    out.writeBoolean(meta.getValue() != null);
                    if (meta.getValue() == null) continue block21;
                }
                case CHAT: {
                    out.writeString((String)DefaultComponentSerializer.get().serialize((Component)meta.getValue()));
                    continue block21;
                }
                case ITEM: {
                    ItemStack.write(out, (ItemStack)meta.getValue());
                    continue block21;
                }
                case BOOLEAN: {
                    out.writeBoolean(((Boolean)meta.getValue()).booleanValue());
                    continue block21;
                }
                case ROTATION: {
                    Rotation.write(out, (Rotation)meta.getValue());
                    continue block21;
                }
                case OPTIONAL_POSITION: {
                    out.writeBoolean(meta.getValue() != null);
                    if (meta.getValue() == null) continue block21;
                }
                case POSITION: {
                    Position.write(out, (Position)meta.getValue());
                    continue block21;
                }
                case BLOCK_FACE: {
                    out.writeVarInt(MagicValues.value(Integer.class, meta.getValue()).intValue());
                    continue block21;
                }
                case OPTIONAL_UUID: {
                    out.writeBoolean(meta.getValue() != null);
                    if (meta.getValue() == null) continue block21;
                    out.writeUUID((UUID)meta.getValue());
                    continue block21;
                }
                case BLOCK_STATE: {
                    out.writeVarInt(((Integer)meta.getValue()).intValue());
                    continue block21;
                }
                case NBT_TAG: {
                    NBT.write(out, (CompoundTag)meta.getValue());
                    continue block21;
                }
                case PARTICLE: {
                    Particle particle = (Particle)meta.getValue();
                    out.writeVarInt(particle.getType().ordinal());
                    ParticleData.write(out, particle.getType(), particle.getData());
                    continue block21;
                }
                case VILLAGER_DATA: {
                    VillagerData villagerData = (VillagerData)meta.getValue();
                    out.writeVarInt(villagerData.getType());
                    out.writeVarInt(villagerData.getProfession());
                    out.writeVarInt(villagerData.getLevel());
                    continue block21;
                }
                case OPTIONAL_VARINT: {
                    OptionalInt optionalInt = (OptionalInt)meta.getValue();
                    out.writeVarInt(optionalInt.orElse(-1) + 1);
                    continue block21;
                }
                case POSE: {
                    out.writeVarInt(MagicValues.value(Integer.class, meta.getValue()).intValue());
                    continue block21;
                }
                default: {
                    throw new IOException("Unknown metadata type: " + (Object)((Object)meta.getType()));
                }
            }
        }
        out.writeByte(255);
    }

    public int getId() {
        return this.id;
    }

    @NonNull
    public MetadataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityMetadata)) {
            return false;
        }
        EntityMetadata other = (EntityMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        MetadataType this$type = this.getType();
        MetadataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        MetadataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "EntityMetadata(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
    }

    public EntityMetadata(int id, @NonNull MetadataType type, Object value) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
        this.value = value;
    }
}

