/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.attribute;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.UnmappedValueException;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierOperation;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierType;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public class AttributeModifier {
    private final ModifierType type;
    @NonNull
    private final UUID uuid;
    private final double amount;
    @NonNull
    private final ModifierOperation operation;

    public AttributeModifier(@NonNull ModifierType type, double amount, @NonNull ModifierOperation operation) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.type = type;
        this.uuid = MagicValues.value(UUID.class, (Object)type);
        this.amount = amount;
        this.operation = operation;
    }

    public AttributeModifier(@NonNull UUID uuid, double amount, @NonNull ModifierOperation operation) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        ModifierType type = null;
        try {
            type = MagicValues.key(ModifierType.class, uuid);
        }
        catch (UnmappedValueException unmappedValueException) {
            // empty catch block
        }
        this.type = type;
        this.uuid = uuid;
        this.amount = amount;
        this.operation = operation;
    }

    public Optional<ModifierType> getType() {
        return Optional.ofNullable(this.type);
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    public double getAmount() {
        return this.amount;
    }

    @NonNull
    public ModifierOperation getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier other = (AttributeModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        Optional<ModifierType> this$type = this.getType();
        Optional<ModifierType> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        ModifierOperation this$operation = this.getOperation();
        ModifierOperation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        Optional<ModifierType> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        ModifierOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeModifier(type=" + this.getType() + ", uuid=" + this.getUuid() + ", amount=" + this.getAmount() + ", operation=" + (Object)((Object)this.getOperation()) + ")";
    }
}

