/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.attribute;

import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeModifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class Attribute {
    @NonNull
    private final AttributeType type;
    private final double value;
    @NonNull
    private final List<AttributeModifier> modifiers;

    public Attribute(@NonNull AttributeType type) {
        this(type, type.getDef());
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public Attribute(@NonNull AttributeType type, double value) {
        this(type, value, new ArrayList<AttributeModifier>());
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    @NonNull
    public AttributeType getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    @NonNull
    public List<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<AttributeModifier> this$modifiers = this.getModifiers();
        List<AttributeModifier> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<AttributeModifier> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    public String toString() {
        return "Attribute(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ", modifiers=" + this.getModifiers() + ")";
    }

    public Attribute(@NonNull AttributeType type, double value, @NonNull List<AttributeModifier> modifiers) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (modifiers == null) {
            throw new NullPointerException("modifiers is marked non-null but is null");
        }
        this.type = type;
        this.value = value;
        this.modifiers = modifiers;
    }
}

