/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import com.github.steveice10.mc.protocol.data.game.chunk.Chunk;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import java.util.Arrays;
import lombok.NonNull;

public class Column {
    private final int x;
    private final int z;
    @NonNull
    private final Chunk[] chunks;
    @NonNull
    private final CompoundTag[] tileEntities;
    @NonNull
    private final CompoundTag heightMaps;
    @NonNull
    private final int[] biomeData;

    @Deprecated
    public Column(int x, int z, @NonNull Chunk[] chunks, @NonNull CompoundTag[] tileEntities, @NonNull CompoundTag heightMaps) {
        this(x, z, chunks, tileEntities, heightMaps, new int[1024]);
        if (chunks == null) {
            throw new NullPointerException("chunks is marked non-null but is null");
        }
        if (tileEntities == null) {
            throw new NullPointerException("tileEntities is marked non-null but is null");
        }
        if (heightMaps == null) {
            throw new NullPointerException("heightMaps is marked non-null but is null");
        }
    }

    public Column(int x, int z, @NonNull Chunk[] chunks, @NonNull CompoundTag[] tileEntities, @NonNull CompoundTag heightMaps, @NonNull int[] biomeData) {
        if (chunks == null) {
            throw new NullPointerException("chunks is marked non-null but is null");
        }
        if (tileEntities == null) {
            throw new NullPointerException("tileEntities is marked non-null but is null");
        }
        if (heightMaps == null) {
            throw new NullPointerException("heightMaps is marked non-null but is null");
        }
        if (biomeData == null) {
            throw new NullPointerException("biomeData is marked non-null but is null");
        }
        this.x = x;
        this.z = z;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.biomeData = biomeData != null ? Arrays.copyOf(biomeData, biomeData.length) : null;
        this.tileEntities = tileEntities != null ? tileEntities : new CompoundTag[]{};
        this.heightMaps = heightMaps;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NonNull
    public Chunk[] getChunks() {
        return this.chunks;
    }

    @NonNull
    public CompoundTag[] getTileEntities() {
        return this.tileEntities;
    }

    @NonNull
    public CompoundTag getHeightMaps() {
        return this.heightMaps;
    }

    @NonNull
    public int[] getBiomeData() {
        return this.biomeData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getChunks(), other.getChunks())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTileEntities(), other.getTileEntities())) {
            return false;
        }
        CompoundTag this$heightMaps = this.getHeightMaps();
        CompoundTag other$heightMaps = other.getHeightMaps();
        if (this$heightMaps == null ? other$heightMaps != null : !this$heightMaps.equals(other$heightMaps)) {
            return false;
        }
        return Arrays.equals(this.getBiomeData(), other.getBiomeData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        result = result * 59 + Arrays.deepHashCode(this.getChunks());
        result = result * 59 + Arrays.deepHashCode(this.getTileEntities());
        CompoundTag $heightMaps = this.getHeightMaps();
        result = result * 59 + ($heightMaps == null ? 43 : $heightMaps.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBiomeData());
        return result;
    }

    public String toString() {
        return "Column(x=" + this.getX() + ", z=" + this.getZ() + ", chunks=" + Arrays.deepToString(this.getChunks()) + ", tileEntities=" + Arrays.deepToString(this.getTileEntities()) + ", heightMaps=" + this.getHeightMaps() + ", biomeData=" + Arrays.toString(this.getBiomeData()) + ")";
    }
}

