/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import com.github.steveice10.mc.protocol.data.game.chunk.BitStorage;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.GlobalPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.ListPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.MapPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import lombok.NonNull;

public class Chunk {
    private static final int CHUNK_SIZE = 4096;
    private static final int MIN_PALETTE_BITS_PER_ENTRY = 4;
    private static final int MAX_PALETTE_BITS_PER_ENTRY = 8;
    private static final int GLOBAL_PALETTE_BITS_PER_ENTRY = 14;
    private static final int AIR = 0;
    private int blockCount;
    @NonNull
    private Palette palette;
    @NonNull
    private BitStorage storage;

    public Chunk() {
        this(0, new ListPalette(4), new BitStorage(4, 4096));
    }

    public static Chunk read(NetInput in) throws IOException {
        short blockCount = in.readShort();
        int bitsPerEntry = in.readUnsignedByte();
        Palette palette = Chunk.readPalette(bitsPerEntry, in);
        BitStorage storage = new BitStorage(bitsPerEntry, 4096, in.readLongs(in.readVarInt()));
        return new Chunk(blockCount, palette, storage);
    }

    public static void write(NetOutput out, Chunk chunk) throws IOException {
        out.writeShort(chunk.blockCount);
        out.writeByte(chunk.storage.getBitsPerEntry());
        if (!(chunk.palette instanceof GlobalPalette)) {
            int paletteLength = chunk.palette.size();
            out.writeVarInt(paletteLength);
            for (int i = 0; i < paletteLength; ++i) {
                out.writeVarInt(chunk.palette.idToState(i));
            }
        }
        long[] data = chunk.storage.getData();
        out.writeVarInt(data.length);
        out.writeLongs(data);
    }

    public int get(int x, int y, int z) {
        int id = this.storage.get(Chunk.index(x, y, z));
        return this.palette.idToState(id);
    }

    public void set(int x, int y, int z, @NonNull int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resizePalette();
            id = this.palette.stateToId(state);
        }
        int index = Chunk.index(x, y, z);
        int curr = this.storage.get(index);
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
        this.storage.set(index, id);
    }

    public boolean isEmpty() {
        return this.blockCount == 0;
    }

    private int sanitizeBitsPerEntry(int bitsPerEntry) {
        if (bitsPerEntry <= 8) {
            return Math.max(4, bitsPerEntry);
        }
        return 14;
    }

    private void resizePalette() {
        Palette oldPalette = this.palette;
        BitStorage oldData = this.storage;
        int bitsPerEntry = this.sanitizeBitsPerEntry(oldData.getBitsPerEntry() + 1);
        this.palette = Chunk.createPalette(bitsPerEntry);
        this.storage = new BitStorage(bitsPerEntry, 4096);
        for (int i = 0; i < 4096; ++i) {
            this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
        }
    }

    private static Palette createPalette(int bitsPerEntry) {
        if (bitsPerEntry <= 4) {
            return new ListPalette(bitsPerEntry);
        }
        if (bitsPerEntry <= 8) {
            return new MapPalette(bitsPerEntry);
        }
        return new GlobalPalette();
    }

    private static Palette readPalette(int bitsPerEntry, NetInput in) throws IOException {
        if (bitsPerEntry <= 4) {
            return new ListPalette(bitsPerEntry, in);
        }
        if (bitsPerEntry <= 8) {
            return new MapPalette(bitsPerEntry, in);
        }
        return new GlobalPalette();
    }

    private static int index(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    @NonNull
    public Palette getPalette() {
        return this.palette;
    }

    @NonNull
    public BitStorage getStorage() {
        return this.storage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockCount() != other.getBlockCount()) {
            return false;
        }
        Palette this$palette = this.getPalette();
        Palette other$palette = other.getPalette();
        if (this$palette == null ? other$palette != null : !this$palette.equals(other$palette)) {
            return false;
        }
        BitStorage this$storage = this.getStorage();
        BitStorage other$storage = other.getStorage();
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockCount();
        Palette $palette = this.getPalette();
        result = result * 59 + ($palette == null ? 43 : $palette.hashCode());
        BitStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }

    public String toString() {
        return "Chunk(blockCount=" + this.getBlockCount() + ", palette=" + this.getPalette() + ", storage=" + this.getStorage() + ")";
    }

    public Chunk(int blockCount, @NonNull Palette palette, @NonNull BitStorage storage) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        this.blockCount = blockCount;
        this.palette = palette;
        this.storage = storage;
    }
}

