/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class PlayerListEntry {
    @NonNull
    private final GameProfile profile;
    private final GameMode gameMode;
    private final int ping;
    private final Component displayName;

    public PlayerListEntry(GameProfile profile) {
        this(profile, null, 0, null);
    }

    public PlayerListEntry(GameProfile profile, GameMode gameMode) {
        this(profile, gameMode, 0, null);
    }

    public PlayerListEntry(GameProfile profile, int ping) {
        this(profile, null, ping, null);
    }

    public PlayerListEntry(GameProfile profile, Component displayName) {
        this(profile, null, 0, displayName);
    }

    @NonNull
    public GameProfile getProfile() {
        return this.profile;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public int getPing() {
        return this.ping;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListEntry)) {
            return false;
        }
        PlayerListEntry other = (PlayerListEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPing() != other.getPing()) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerListEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPing();
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerListEntry(profile=" + this.getProfile() + ", gameMode=" + this.getGameMode() + ", ping=" + this.getPing() + ", displayName=" + this.getDisplayName() + ")";
    }

    public PlayerListEntry(@NonNull GameProfile profile, GameMode gameMode, int ping, Component displayName) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.profile = profile;
        this.gameMode = gameMode;
        this.ping = ping;
        this.displayName = displayName;
    }
}

