/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.SessionService;
import com.github.steveice10.mc.protocol.MinecraftProtocol;
import com.github.steveice10.mc.protocol.ServerLoginHandler;
import com.github.steveice10.mc.protocol.data.SubProtocol;
import com.github.steveice10.mc.protocol.data.status.PlayerInfo;
import com.github.steveice10.mc.protocol.data.status.ServerStatusInfo;
import com.github.steveice10.mc.protocol.data.status.VersionInfo;
import com.github.steveice10.mc.protocol.data.status.handler.ServerInfoBuilder;
import com.github.steveice10.mc.protocol.packet.handshake.client.HandshakePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.login.client.EncryptionResponsePacket;
import com.github.steveice10.mc.protocol.packet.login.client.LoginStartPacket;
import com.github.steveice10.mc.protocol.packet.login.server.EncryptionRequestPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSetCompressionPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSuccessPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusPingPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusQueryPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusPongPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusResponsePacket;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.session.ConnectedEvent;
import com.github.steveice10.packetlib.event.session.DisconnectingEvent;
import com.github.steveice10.packetlib.event.session.PacketReceivedEvent;
import com.github.steveice10.packetlib.event.session.PacketSentEvent;
import com.github.steveice10.packetlib.event.session.SessionAdapter;
import com.github.steveice10.packetlib.packet.Packet;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;

public class ServerListener
extends SessionAdapter {
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    private static final String SERVER_ID = "";
    private static final KeyPair KEY_PAIR;
    private byte[] verifyToken = new byte[4];
    private String username = "";
    private long lastPingTime = 0L;
    private int lastPingId = 0;

    public ServerListener() {
        new Random().nextBytes(this.verifyToken);
    }

    public void connected(ConnectedEvent event) {
        event.getSession().setFlag("ping", (Object)0);
    }

    public void packetReceived(PacketReceivedEvent event) {
        Object packet;
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getSubProtocol() == SubProtocol.HANDSHAKE && event.getPacket() instanceof HandshakePacket) {
            packet = (HandshakePacket)event.getPacket();
            switch (((HandshakePacket)packet).getIntent()) {
                case STATUS: {
                    protocol.setSubProtocol(SubProtocol.STATUS, false, event.getSession());
                    break;
                }
                case LOGIN: {
                    protocol.setSubProtocol(SubProtocol.LOGIN, false, event.getSession());
                    if (((HandshakePacket)packet).getProtocolVersion() > 756) {
                        event.getSession().disconnect("Outdated server! I'm still on 1.17.1.");
                        break;
                    }
                    if (((HandshakePacket)packet).getProtocolVersion() >= 756) break;
                    event.getSession().disconnect("Outdated client! Please use 1.17.1.");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid client intent: " + (Object)((Object)((HandshakePacket)packet).getIntent()));
                }
            }
        }
        if (protocol.getSubProtocol() == SubProtocol.LOGIN) {
            if (event.getPacket() instanceof LoginStartPacket) {
                this.username = ((LoginStartPacket)event.getPacket()).getUsername();
                if (((Boolean)event.getSession().getFlag("verify-users", (Object)true)).booleanValue()) {
                    event.getSession().send((Packet)new EncryptionRequestPacket(SERVER_ID, KEY_PAIR.getPublic(), this.verifyToken));
                } else {
                    new Thread(new UserAuthTask(event.getSession(), null)).start();
                }
            } else if (event.getPacket() instanceof EncryptionResponsePacket) {
                PrivateKey privateKey;
                packet = (EncryptionResponsePacket)event.getPacket();
                if (!Arrays.equals(this.verifyToken, ((EncryptionResponsePacket)packet).getVerifyToken(privateKey = KEY_PAIR.getPrivate()))) {
                    event.getSession().disconnect("Invalid nonce!");
                    return;
                }
                SecretKey key = ((EncryptionResponsePacket)packet).getSecretKey(privateKey);
                protocol.enableEncryption(key);
                new Thread(new UserAuthTask(event.getSession(), key)).start();
            }
        }
        if (protocol.getSubProtocol() == SubProtocol.STATUS) {
            if (event.getPacket() instanceof StatusQueryPacket) {
                ServerInfoBuilder builder = (ServerInfoBuilder)event.getSession().getFlag("info-builder");
                if (builder == null) {
                    builder = session -> new ServerStatusInfo(VersionInfo.CURRENT, new PlayerInfo(0, 20, new GameProfile[0]), (Component)Component.text((String)"A Minecraft Server"), null);
                }
                ServerStatusInfo info = builder.buildInfo(event.getSession());
                event.getSession().send((Packet)new StatusResponsePacket(info));
            } else if (event.getPacket() instanceof StatusPingPacket) {
                event.getSession().send((Packet)new StatusPongPacket(((StatusPingPacket)event.getPacket()).getPingTime()));
            }
        }
        if (protocol.getSubProtocol() == SubProtocol.GAME && event.getPacket() instanceof ClientKeepAlivePacket && ((ClientKeepAlivePacket)(packet = (ClientKeepAlivePacket)event.getPacket())).getPingId() == (long)this.lastPingId) {
            long time = System.currentTimeMillis() - this.lastPingTime;
            event.getSession().setFlag("ping", (Object)time);
        }
    }

    public void packetSent(PacketSentEvent event) {
        Session session = event.getSession();
        if (event.getPacket() instanceof LoginSetCompressionPacket) {
            session.setCompressionThreshold(((LoginSetCompressionPacket)event.getPacket()).getThreshold());
            session.send((Packet)new LoginSuccessPacket((GameProfile)session.getFlag("profile")));
        } else if (event.getPacket() instanceof LoginSuccessPacket) {
            ((MinecraftProtocol)session.getPacketProtocol()).setSubProtocol(SubProtocol.GAME, false, session);
            ServerLoginHandler handler = (ServerLoginHandler)session.getFlag("login-handler");
            if (handler != null) {
                handler.loggedIn(session);
            }
            if (((Boolean)event.getSession().getFlag("manage-keep-alive", (Object)true)).booleanValue()) {
                new Thread(new KeepAliveTask(session)).start();
            }
        }
    }

    public void disconnecting(DisconnectingEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getSubProtocol() == SubProtocol.LOGIN) {
            event.getSession().send((Packet)new LoginDisconnectPacket(event.getReason()));
        } else if (protocol.getSubProtocol() == SubProtocol.GAME) {
            event.getSession().send((Packet)new ServerDisconnectPacket(event.getReason()));
        }
    }

    static {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024);
            KEY_PAIR = gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate server key pair.", e);
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private Session session;

        public KeepAliveTask(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            while (this.session.isConnected()) {
                ServerListener.this.lastPingTime = System.currentTimeMillis();
                ServerListener.this.lastPingId = (int)ServerListener.this.lastPingTime;
                this.session.send((Packet)new ServerKeepAlivePacket(ServerListener.this.lastPingId));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    private class UserAuthTask
    implements Runnable {
        private Session session;
        private SecretKey key;

        public UserAuthTask(Session session, SecretKey key) {
            this.key = key;
            this.session = session;
        }

        @Override
        public void run() {
            GameProfile profile = null;
            if (this.key != null) {
                SessionService sessionService = (SessionService)this.session.getFlag("session-service", (Object)new SessionService());
                try {
                    profile = sessionService.getProfileByServer(ServerListener.this.username, sessionService.getServerId(ServerListener.SERVER_ID, KEY_PAIR.getPublic(), this.key));
                }
                catch (RequestException e) {
                    this.session.disconnect("Failed to make session service request.", (Throwable)e);
                    return;
                }
                if (profile == null) {
                    this.session.disconnect("Failed to verify username.");
                }
            } else {
                profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + ServerListener.this.username).getBytes()), ServerListener.this.username);
            }
            this.session.setFlag("profile", (Object)profile);
            int threshold = (Integer)this.session.getFlag("compression-threshold", (Object)256);
            this.session.send((Packet)new LoginSetCompressionPacket(threshold));
        }
    }
}

