/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.ClientListener;
import com.github.steveice10.mc.protocol.ServerListener;
import com.github.steveice10.mc.protocol.data.SubProtocol;
import com.github.steveice10.mc.protocol.packet.handshake.client.HandshakePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientChatPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientLockDifficultyPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientPluginMessagePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientPongPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientRequestPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientResourcePackStatusPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientSetDifficultyPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientSettingsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientTabCompletePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerAbilitiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerChangeHeldItemPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerInteractEntityPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerMovementPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerPlaceBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerPositionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerPositionRotationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerRotationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerStatePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerSwingArmPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.player.ClientPlayerUseItemPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientAdvancementTabPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientClickWindowButtonPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientCloseWindowPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientCraftingBookStatePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientCreativeInventoryActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientDisplayedRecipePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientEditBookPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientMoveItemToHotbarPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientPrepareCraftingGridPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientRenameItemPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientSelectTradePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientSetBeaconEffectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientUpdateCommandBlockMinecartPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientUpdateCommandBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientUpdateJigsawBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientUpdateStructureBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.window.ClientWindowActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientBlockNBTRequestPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientEntityNBTRequestPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientGenerateStructuresPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientSpectatePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientSteerBoatPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientSteerVehiclePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientTeleportConfirmPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientUpdateSignPacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.world.ClientVehicleMovePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerAdvancementTabPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerAdvancementsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerBossBarPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerChatPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDeclareCommandsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDeclareRecipesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDeclareTagsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDifficultyPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerEntitySoundEffectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerJoinGamePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerPingPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerPlayerListDataPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerPlayerListEntryPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerPluginMessagePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerResourcePackSendPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerRespawnPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerSetCooldownPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerStatisticsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerStopSoundPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerSwitchCameraPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerTabCompletePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerUnlockRecipesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityAnimationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityAttachPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityCollectItemPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityEffectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityEquipmentPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityHeadLookPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityMetadataPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityPositionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityPositionRotationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityPropertiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityRemoveEffectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityRotationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntitySetPassengersPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityStatusPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityTeleportPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerEntityVelocityPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerRemoveEntitiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.ServerVehicleMovePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerAbilitiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerActionAckPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerChangeHeldItemPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerCombatEndPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerCombatEnterPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerCombatKillPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerFacingPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerHealthPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerPositionRotationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.player.ServerPlayerSetExperiencePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn.ServerSpawnEntityPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn.ServerSpawnExpOrbPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn.ServerSpawnLivingEntityPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn.ServerSpawnPaintingPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn.ServerSpawnPlayerPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard.ServerDisplayScoreboardPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard.ServerScoreboardObjectivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard.ServerTeamPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard.ServerUpdateScorePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.title.ServerClearTitlesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.title.ServerSetActionBarTextPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.title.ServerSetSubtitleTextPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.title.ServerSetTitleTextPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.title.ServerSetTitlesAnimationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerCloseWindowPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerOpenBookPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerOpenHorseWindowPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerOpenWindowPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerPreparedCraftingGridPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerSetSlotPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerTradeListPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerWindowItemsPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.window.ServerWindowPropertyPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerAddVibrationSignalPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerBlockBreakAnimPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerBlockChangePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerBlockValuePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerChunkDataPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerExplosionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerMapDataPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerMultiBlockChangePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerNBTResponsePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerNotifyClientPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerOpenTileEntityEditorPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerPlayBuiltinSoundPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerPlayEffectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerPlaySoundPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerSpawnParticlePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerSpawnPositionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUnloadChunkPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUpdateLightPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUpdateTileEntityPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUpdateTimePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUpdateViewDistancePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.ServerUpdateViewPositionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerInitializeBorderPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerSetBorderCenterPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerSetBorderLerpSizePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerSetBorderSizePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerSetBorderWarningDelayPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.world.border.ServerSetBorderWarningDistancePacket;
import com.github.steveice10.mc.protocol.packet.login.client.EncryptionResponsePacket;
import com.github.steveice10.mc.protocol.packet.login.client.LoginPluginResponsePacket;
import com.github.steveice10.mc.protocol.packet.login.client.LoginStartPacket;
import com.github.steveice10.mc.protocol.packet.login.server.EncryptionRequestPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginPluginRequestPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSetCompressionPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSuccessPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusPingPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusQueryPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusPongPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusResponsePacket;
import com.github.steveice10.packetlib.Server;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.crypt.AESEncryption;
import com.github.steveice10.packetlib.crypt.PacketEncryption;
import com.github.steveice10.packetlib.event.session.SessionListener;
import com.github.steveice10.packetlib.packet.DefaultPacketHeader;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.packet.PacketHeader;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.NonNull;

public class MinecraftProtocol
extends PacketProtocol {
    private SubProtocol subProtocol = SubProtocol.HANDSHAKE;
    private final PacketHeader packetHeader = new DefaultPacketHeader();
    private AESEncryption encryption;
    private SubProtocol targetSubProtocol;
    private GameProfile profile;
    private String accessToken;
    private boolean useDefaultListeners = true;

    public MinecraftProtocol() {
        this.targetSubProtocol = SubProtocol.STATUS;
    }

    public MinecraftProtocol(@NonNull String username) {
        this(new GameProfile((UUID)null, username), null);
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull GameProfile profile, String accessToken) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.targetSubProtocol = SubProtocol.LOGIN;
        this.profile = profile;
        this.accessToken = accessToken;
    }

    public String getSRVRecordPrefix() {
        return "_minecraft";
    }

    public PacketHeader getPacketHeader() {
        return this.packetHeader;
    }

    public PacketEncryption getEncryption() {
        return this.encryption;
    }

    public void newClientSession(Session session) {
        session.setFlag("profile", (Object)this.profile);
        session.setFlag("access-token", (Object)this.accessToken);
        this.setSubProtocol(SubProtocol.HANDSHAKE, true, session);
        if (this.useDefaultListeners) {
            session.addListener((SessionListener)new ClientListener(this.targetSubProtocol));
        }
    }

    public void newServerSession(Server server, Session session) {
        this.setSubProtocol(SubProtocol.HANDSHAKE, false, session);
        if (this.useDefaultListeners) {
            session.addListener((SessionListener)new ServerListener());
        }
    }

    protected void enableEncryption(Key key) {
        try {
            this.encryption = new AESEncryption(key);
        }
        catch (GeneralSecurityException e) {
            throw new Error("Failed to enable protocol encryption.", e);
        }
    }

    public SubProtocol getSubProtocol() {
        return this.subProtocol;
    }

    protected void setSubProtocol(SubProtocol subProtocol, boolean client, Session session) {
        this.clearPackets();
        switch (subProtocol) {
            case HANDSHAKE: {
                if (client) {
                    this.initClientHandshake();
                    break;
                }
                this.initServerHandshake();
                break;
            }
            case LOGIN: {
                if (client) {
                    this.initLogin((arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1));
                    break;
                }
                this.initLogin((arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1));
                break;
            }
            case GAME: {
                if (client) {
                    this.initGame((arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1));
                    break;
                }
                this.initGame((arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1));
                break;
            }
            case STATUS: {
                if (client) {
                    this.initStatus((arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1));
                    break;
                }
                this.initStatus((arg_0, arg_1) -> ((MinecraftProtocol)this).registerOutgoing(arg_0, arg_1), (arg_0, arg_1) -> ((MinecraftProtocol)this).registerIncoming(arg_0, arg_1));
            }
        }
        this.subProtocol = subProtocol;
    }

    private void initClientHandshake() {
        this.registerOutgoing(0, HandshakePacket.class);
    }

    private void initServerHandshake() {
        this.registerIncoming(0, HandshakePacket.class);
    }

    private void initLogin(BiConsumer<Integer, Class<? extends Packet>> clientboundPackets, BiConsumer<Integer, Class<? extends Packet>> serverboundPackets) {
        clientboundPackets.accept(0, LoginDisconnectPacket.class);
        clientboundPackets.accept(1, EncryptionRequestPacket.class);
        clientboundPackets.accept(2, LoginSuccessPacket.class);
        clientboundPackets.accept(3, LoginSetCompressionPacket.class);
        clientboundPackets.accept(4, LoginPluginRequestPacket.class);
        serverboundPackets.accept(0, LoginStartPacket.class);
        serverboundPackets.accept(1, EncryptionResponsePacket.class);
        serverboundPackets.accept(2, LoginPluginResponsePacket.class);
    }

    private void initGame(BiConsumer<Integer, Class<? extends Packet>> clientboundPackets, BiConsumer<Integer, Class<? extends Packet>> serverboundPackets) {
        clientboundPackets.accept(0, ServerSpawnEntityPacket.class);
        clientboundPackets.accept(1, ServerSpawnExpOrbPacket.class);
        clientboundPackets.accept(2, ServerSpawnLivingEntityPacket.class);
        clientboundPackets.accept(3, ServerSpawnPaintingPacket.class);
        clientboundPackets.accept(4, ServerSpawnPlayerPacket.class);
        clientboundPackets.accept(5, ServerAddVibrationSignalPacket.class);
        clientboundPackets.accept(6, ServerEntityAnimationPacket.class);
        clientboundPackets.accept(7, ServerStatisticsPacket.class);
        clientboundPackets.accept(8, ServerPlayerActionAckPacket.class);
        clientboundPackets.accept(9, ServerBlockBreakAnimPacket.class);
        clientboundPackets.accept(10, ServerUpdateTileEntityPacket.class);
        clientboundPackets.accept(11, ServerBlockValuePacket.class);
        clientboundPackets.accept(12, ServerBlockChangePacket.class);
        clientboundPackets.accept(13, ServerBossBarPacket.class);
        clientboundPackets.accept(14, ServerDifficultyPacket.class);
        clientboundPackets.accept(15, ServerChatPacket.class);
        clientboundPackets.accept(16, ServerClearTitlesPacket.class);
        clientboundPackets.accept(17, ServerTabCompletePacket.class);
        clientboundPackets.accept(18, ServerDeclareCommandsPacket.class);
        clientboundPackets.accept(19, ServerCloseWindowPacket.class);
        clientboundPackets.accept(20, ServerWindowItemsPacket.class);
        clientboundPackets.accept(21, ServerWindowPropertyPacket.class);
        clientboundPackets.accept(22, ServerSetSlotPacket.class);
        clientboundPackets.accept(23, ServerSetCooldownPacket.class);
        clientboundPackets.accept(24, ServerPluginMessagePacket.class);
        clientboundPackets.accept(25, ServerPlaySoundPacket.class);
        clientboundPackets.accept(26, ServerDisconnectPacket.class);
        clientboundPackets.accept(27, ServerEntityStatusPacket.class);
        clientboundPackets.accept(28, ServerExplosionPacket.class);
        clientboundPackets.accept(29, ServerUnloadChunkPacket.class);
        clientboundPackets.accept(30, ServerNotifyClientPacket.class);
        clientboundPackets.accept(31, ServerOpenHorseWindowPacket.class);
        clientboundPackets.accept(32, ServerInitializeBorderPacket.class);
        clientboundPackets.accept(33, ServerKeepAlivePacket.class);
        clientboundPackets.accept(34, ServerChunkDataPacket.class);
        clientboundPackets.accept(35, ServerPlayEffectPacket.class);
        clientboundPackets.accept(36, ServerSpawnParticlePacket.class);
        clientboundPackets.accept(37, ServerUpdateLightPacket.class);
        clientboundPackets.accept(38, ServerJoinGamePacket.class);
        clientboundPackets.accept(39, ServerMapDataPacket.class);
        clientboundPackets.accept(40, ServerTradeListPacket.class);
        clientboundPackets.accept(41, ServerEntityPositionPacket.class);
        clientboundPackets.accept(42, ServerEntityPositionRotationPacket.class);
        clientboundPackets.accept(43, ServerEntityRotationPacket.class);
        clientboundPackets.accept(44, ServerVehicleMovePacket.class);
        clientboundPackets.accept(45, ServerOpenBookPacket.class);
        clientboundPackets.accept(46, ServerOpenWindowPacket.class);
        clientboundPackets.accept(47, ServerOpenTileEntityEditorPacket.class);
        clientboundPackets.accept(48, ServerPingPacket.class);
        clientboundPackets.accept(49, ServerPreparedCraftingGridPacket.class);
        clientboundPackets.accept(50, ServerPlayerAbilitiesPacket.class);
        clientboundPackets.accept(51, ServerPlayerCombatEndPacket.class);
        clientboundPackets.accept(52, ServerPlayerCombatEnterPacket.class);
        clientboundPackets.accept(53, ServerPlayerCombatKillPacket.class);
        clientboundPackets.accept(54, ServerPlayerListEntryPacket.class);
        clientboundPackets.accept(55, ServerPlayerFacingPacket.class);
        clientboundPackets.accept(56, ServerPlayerPositionRotationPacket.class);
        clientboundPackets.accept(57, ServerUnlockRecipesPacket.class);
        clientboundPackets.accept(58, ServerRemoveEntitiesPacket.class);
        clientboundPackets.accept(59, ServerEntityRemoveEffectPacket.class);
        clientboundPackets.accept(60, ServerResourcePackSendPacket.class);
        clientboundPackets.accept(61, ServerRespawnPacket.class);
        clientboundPackets.accept(62, ServerEntityHeadLookPacket.class);
        clientboundPackets.accept(63, ServerMultiBlockChangePacket.class);
        clientboundPackets.accept(64, ServerAdvancementTabPacket.class);
        clientboundPackets.accept(65, ServerSetActionBarTextPacket.class);
        clientboundPackets.accept(66, ServerSetBorderCenterPacket.class);
        clientboundPackets.accept(67, ServerSetBorderLerpSizePacket.class);
        clientboundPackets.accept(68, ServerSetBorderSizePacket.class);
        clientboundPackets.accept(69, ServerSetBorderWarningDelayPacket.class);
        clientboundPackets.accept(70, ServerSetBorderWarningDistancePacket.class);
        clientboundPackets.accept(71, ServerSwitchCameraPacket.class);
        clientboundPackets.accept(72, ServerPlayerChangeHeldItemPacket.class);
        clientboundPackets.accept(73, ServerUpdateViewPositionPacket.class);
        clientboundPackets.accept(74, ServerUpdateViewDistancePacket.class);
        clientboundPackets.accept(75, ServerSpawnPositionPacket.class);
        clientboundPackets.accept(76, ServerDisplayScoreboardPacket.class);
        clientboundPackets.accept(77, ServerEntityMetadataPacket.class);
        clientboundPackets.accept(78, ServerEntityAttachPacket.class);
        clientboundPackets.accept(79, ServerEntityVelocityPacket.class);
        clientboundPackets.accept(80, ServerEntityEquipmentPacket.class);
        clientboundPackets.accept(81, ServerPlayerSetExperiencePacket.class);
        clientboundPackets.accept(82, ServerPlayerHealthPacket.class);
        clientboundPackets.accept(83, ServerScoreboardObjectivePacket.class);
        clientboundPackets.accept(84, ServerEntitySetPassengersPacket.class);
        clientboundPackets.accept(85, ServerTeamPacket.class);
        clientboundPackets.accept(86, ServerUpdateScorePacket.class);
        clientboundPackets.accept(87, ServerSetSubtitleTextPacket.class);
        clientboundPackets.accept(88, ServerUpdateTimePacket.class);
        clientboundPackets.accept(89, ServerSetTitleTextPacket.class);
        clientboundPackets.accept(90, ServerSetTitlesAnimationPacket.class);
        clientboundPackets.accept(91, ServerEntitySoundEffectPacket.class);
        clientboundPackets.accept(92, ServerPlayBuiltinSoundPacket.class);
        clientboundPackets.accept(93, ServerStopSoundPacket.class);
        clientboundPackets.accept(94, ServerPlayerListDataPacket.class);
        clientboundPackets.accept(95, ServerNBTResponsePacket.class);
        clientboundPackets.accept(96, ServerEntityCollectItemPacket.class);
        clientboundPackets.accept(97, ServerEntityTeleportPacket.class);
        clientboundPackets.accept(98, ServerAdvancementsPacket.class);
        clientboundPackets.accept(99, ServerEntityPropertiesPacket.class);
        clientboundPackets.accept(100, ServerEntityEffectPacket.class);
        clientboundPackets.accept(101, ServerDeclareRecipesPacket.class);
        clientboundPackets.accept(102, ServerDeclareTagsPacket.class);
        serverboundPackets.accept(0, ClientTeleportConfirmPacket.class);
        serverboundPackets.accept(1, ClientBlockNBTRequestPacket.class);
        serverboundPackets.accept(2, ClientSetDifficultyPacket.class);
        serverboundPackets.accept(3, ClientChatPacket.class);
        serverboundPackets.accept(4, ClientRequestPacket.class);
        serverboundPackets.accept(5, ClientSettingsPacket.class);
        serverboundPackets.accept(6, ClientTabCompletePacket.class);
        serverboundPackets.accept(7, ClientClickWindowButtonPacket.class);
        serverboundPackets.accept(8, ClientWindowActionPacket.class);
        serverboundPackets.accept(9, ClientCloseWindowPacket.class);
        serverboundPackets.accept(10, ClientPluginMessagePacket.class);
        serverboundPackets.accept(11, ClientEditBookPacket.class);
        serverboundPackets.accept(12, ClientEntityNBTRequestPacket.class);
        serverboundPackets.accept(13, ClientPlayerInteractEntityPacket.class);
        serverboundPackets.accept(14, ClientGenerateStructuresPacket.class);
        serverboundPackets.accept(15, ClientKeepAlivePacket.class);
        serverboundPackets.accept(16, ClientLockDifficultyPacket.class);
        serverboundPackets.accept(17, ClientPlayerPositionPacket.class);
        serverboundPackets.accept(18, ClientPlayerPositionRotationPacket.class);
        serverboundPackets.accept(19, ClientPlayerRotationPacket.class);
        serverboundPackets.accept(20, ClientPlayerMovementPacket.class);
        serverboundPackets.accept(21, ClientVehicleMovePacket.class);
        serverboundPackets.accept(22, ClientSteerBoatPacket.class);
        serverboundPackets.accept(23, ClientMoveItemToHotbarPacket.class);
        serverboundPackets.accept(24, ClientPrepareCraftingGridPacket.class);
        serverboundPackets.accept(25, ClientPlayerAbilitiesPacket.class);
        serverboundPackets.accept(26, ClientPlayerActionPacket.class);
        serverboundPackets.accept(27, ClientPlayerStatePacket.class);
        serverboundPackets.accept(28, ClientSteerVehiclePacket.class);
        serverboundPackets.accept(29, ClientPongPacket.class);
        serverboundPackets.accept(30, ClientCraftingBookStatePacket.class);
        serverboundPackets.accept(31, ClientDisplayedRecipePacket.class);
        serverboundPackets.accept(32, ClientRenameItemPacket.class);
        serverboundPackets.accept(33, ClientResourcePackStatusPacket.class);
        serverboundPackets.accept(34, ClientAdvancementTabPacket.class);
        serverboundPackets.accept(35, ClientSelectTradePacket.class);
        serverboundPackets.accept(36, ClientSetBeaconEffectPacket.class);
        serverboundPackets.accept(37, ClientPlayerChangeHeldItemPacket.class);
        serverboundPackets.accept(38, ClientUpdateCommandBlockPacket.class);
        serverboundPackets.accept(39, ClientUpdateCommandBlockMinecartPacket.class);
        serverboundPackets.accept(40, ClientCreativeInventoryActionPacket.class);
        serverboundPackets.accept(41, ClientUpdateJigsawBlockPacket.class);
        serverboundPackets.accept(42, ClientUpdateStructureBlockPacket.class);
        serverboundPackets.accept(43, ClientUpdateSignPacket.class);
        serverboundPackets.accept(44, ClientPlayerSwingArmPacket.class);
        serverboundPackets.accept(45, ClientSpectatePacket.class);
        serverboundPackets.accept(46, ClientPlayerPlaceBlockPacket.class);
        serverboundPackets.accept(47, ClientPlayerUseItemPacket.class);
    }

    private void initStatus(BiConsumer<Integer, Class<? extends Packet>> clientboundPackets, BiConsumer<Integer, Class<? extends Packet>> serverboundPackets) {
        clientboundPackets.accept(0, StatusResponsePacket.class);
        clientboundPackets.accept(1, StatusPongPacket.class);
        serverboundPackets.accept(0, StatusQueryPacket.class);
        serverboundPackets.accept(1, StatusPingPacket.class);
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }
}

