/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.InvalidCredentialsException;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.exception.request.ServiceUnavailableException;
import com.github.steveice10.mc.auth.service.SessionService;
import com.github.steveice10.mc.protocol.MinecraftProtocol;
import com.github.steveice10.mc.protocol.data.SubProtocol;
import com.github.steveice10.mc.protocol.data.UnexpectedEncryptionException;
import com.github.steveice10.mc.protocol.data.handshake.HandshakeIntent;
import com.github.steveice10.mc.protocol.data.status.ServerStatusInfo;
import com.github.steveice10.mc.protocol.data.status.handler.ServerInfoHandler;
import com.github.steveice10.mc.protocol.data.status.handler.ServerPingTimeHandler;
import com.github.steveice10.mc.protocol.packet.handshake.client.HandshakePacket;
import com.github.steveice10.mc.protocol.packet.ingame.client.ClientKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.ingame.server.ServerKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.login.client.EncryptionResponsePacket;
import com.github.steveice10.mc.protocol.packet.login.client.LoginStartPacket;
import com.github.steveice10.mc.protocol.packet.login.server.EncryptionRequestPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSetCompressionPacket;
import com.github.steveice10.mc.protocol.packet.login.server.LoginSuccessPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusPingPacket;
import com.github.steveice10.mc.protocol.packet.status.client.StatusQueryPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusPongPacket;
import com.github.steveice10.mc.protocol.packet.status.server.StatusResponsePacket;
import com.github.steveice10.packetlib.event.session.ConnectedEvent;
import com.github.steveice10.packetlib.event.session.PacketReceivedEvent;
import com.github.steveice10.packetlib.event.session.PacketSentEvent;
import com.github.steveice10.packetlib.event.session.SessionAdapter;
import com.github.steveice10.packetlib.packet.Packet;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;

public class ClientListener
extends SessionAdapter {
    @NonNull
    private final SubProtocol targetSubProtocol;

    public void packetReceived(PacketReceivedEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getSubProtocol() == SubProtocol.LOGIN) {
            if (event.getPacket() instanceof EncryptionRequestPacket) {
                SecretKey key;
                GameProfile profile = (GameProfile)event.getSession().getFlag("profile");
                String accessToken = (String)event.getSession().getFlag("access-token");
                if (profile == null || accessToken == null) {
                    throw new UnexpectedEncryptionException();
                }
                EncryptionRequestPacket packet = (EncryptionRequestPacket)event.getPacket();
                try {
                    KeyGenerator gen = KeyGenerator.getInstance("AES");
                    gen.init(128);
                    key = gen.generateKey();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Failed to generate shared key.", e);
                }
                SessionService sessionService = (SessionService)event.getSession().getFlag("session-service", (Object)new SessionService());
                String serverId = sessionService.getServerId(packet.getServerId(), packet.getPublicKey(), key);
                try {
                    sessionService.joinServer(profile, accessToken, serverId);
                }
                catch (ServiceUnavailableException e) {
                    event.getSession().disconnect("Login failed: Authentication service unavailable.", (Throwable)e);
                    return;
                }
                catch (InvalidCredentialsException e) {
                    event.getSession().disconnect("Login failed: Invalid login session.", (Throwable)e);
                    return;
                }
                catch (RequestException e) {
                    event.getSession().disconnect("Login failed: Authentication error: " + e.getMessage(), (Throwable)e);
                    return;
                }
                event.getSession().send((Packet)new EncryptionResponsePacket(packet.getPublicKey(), key, packet.getVerifyToken()));
                protocol.enableEncryption(key);
            } else if (event.getPacket() instanceof LoginSuccessPacket) {
                protocol.setSubProtocol(SubProtocol.GAME, true, event.getSession());
            } else if (event.getPacket() instanceof LoginDisconnectPacket) {
                event.getSession().disconnect(((LoginDisconnectPacket)event.getPacket()).getReason().toString());
            } else if (event.getPacket() instanceof LoginSetCompressionPacket) {
                event.getSession().setCompressionThreshold(((LoginSetCompressionPacket)event.getPacket()).getThreshold());
            }
        } else if (protocol.getSubProtocol() == SubProtocol.STATUS) {
            if (event.getPacket() instanceof StatusResponsePacket) {
                ServerStatusInfo info = ((StatusResponsePacket)event.getPacket()).getInfo();
                ServerInfoHandler handler = (ServerInfoHandler)event.getSession().getFlag("server-info-handler");
                if (handler != null) {
                    handler.handle(event.getSession(), info);
                }
                event.getSession().send((Packet)new StatusPingPacket(System.currentTimeMillis()));
            } else if (event.getPacket() instanceof StatusPongPacket) {
                long time = System.currentTimeMillis() - ((StatusPongPacket)event.getPacket()).getPingTime();
                ServerPingTimeHandler handler = (ServerPingTimeHandler)event.getSession().getFlag("server-ping-time-handler");
                if (handler != null) {
                    handler.handle(event.getSession(), time);
                }
                event.getSession().disconnect("Finished");
            }
        } else if (protocol.getSubProtocol() == SubProtocol.GAME) {
            if (event.getPacket() instanceof ServerKeepAlivePacket && ((Boolean)event.getSession().getFlag("manage-keep-alive", (Object)true)).booleanValue()) {
                event.getSession().send((Packet)new ClientKeepAlivePacket(((ServerKeepAlivePacket)event.getPacket()).getPingId()));
            } else if (event.getPacket() instanceof ServerDisconnectPacket) {
                event.getSession().disconnect(((ServerDisconnectPacket)event.getPacket()).getReason().toString());
            }
        }
    }

    public void packetSent(PacketSentEvent event) {
        if (event.getPacket() instanceof HandshakePacket) {
            MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
            protocol.setSubProtocol(this.targetSubProtocol, true, event.getSession());
            if (this.targetSubProtocol == SubProtocol.LOGIN) {
                GameProfile profile = (GameProfile)event.getSession().getFlag("profile");
                event.getSession().send((Packet)new LoginStartPacket(profile.getName()));
            } else {
                event.getSession().send((Packet)new StatusQueryPacket());
            }
        }
    }

    public void connected(ConnectedEvent event) {
        if (this.targetSubProtocol == SubProtocol.LOGIN) {
            event.getSession().send((Packet)new HandshakePacket(756, event.getSession().getHost(), event.getSession().getPort(), HandshakeIntent.LOGIN));
        } else if (this.targetSubProtocol == SubProtocol.STATUS) {
            event.getSession().send((Packet)new HandshakePacket(756, event.getSession().getHost(), event.getSession().getPort(), HandshakeIntent.STATUS));
        }
    }

    public ClientListener(@NonNull SubProtocol targetSubProtocol) {
        if (targetSubProtocol == null) {
            throw new NullPointerException("targetSubProtocol is marked non-null but is null");
        }
        this.targetSubProtocol = targetSubProtocol;
    }
}

