/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerboundPlayerAbilitiesPacket
implements Packet {
    private static final int FLAG_FLYING = 2;
    private final boolean flying;

    public ServerboundPlayerAbilitiesPacket(NetInput in) throws IOException {
        byte flags = in.readByte();
        this.flying = (flags & 2) > 0;
    }

    public void write(NetOutput out) throws IOException {
        int flags = 0;
        if (this.flying) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerAbilitiesPacket)) {
            return false;
        }
        ServerboundPlayerAbilitiesPacket other = (ServerboundPlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isFlying() == other.isFlying();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlayerAbilitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlying() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ServerboundPlayerAbilitiesPacket(flying=" + this.isFlying() + ")";
    }

    public ServerboundPlayerAbilitiesPacket withFlying(boolean flying) {
        return this.flying == flying ? this : new ServerboundPlayerAbilitiesPacket(flying);
    }

    public ServerboundPlayerAbilitiesPacket(boolean flying) {
        this.flying = flying;
    }
}

