/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.level;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerboundSignUpdatePacket
implements Packet {
    @NonNull
    private final Position position;
    @NonNull
    private final String[] lines;

    public ServerboundSignUpdatePacket(@NonNull Position position, @NonNull String[] lines) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.length != 4) {
            throw new IllegalArgumentException("Lines must contain exactly 4 strings.");
        }
        this.position = position;
        this.lines = Arrays.copyOf(lines, lines.length);
    }

    public ServerboundSignUpdatePacket(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.lines = new String[4];
        for (int count = 0; count < this.lines.length; ++count) {
            this.lines[count] = in.readString();
        }
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        for (String line : this.lines) {
            out.writeString(line);
        }
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public String[] getLines() {
        return this.lines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSignUpdatePacket)) {
            return false;
        }
        ServerboundSignUpdatePacket other = (ServerboundSignUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        return Arrays.deepEquals(this.getLines(), other.getLines());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSignUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLines());
        return result;
    }

    public String toString() {
        return "ServerboundSignUpdatePacket(position=" + this.getPosition() + ", lines=" + Arrays.deepToString(this.getLines()) + ")";
    }

    public ServerboundSignUpdatePacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSignUpdatePacket(position, this.lines);
    }

    public ServerboundSignUpdatePacket withLines(@NonNull String[] lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return this.lines == lines ? this : new ServerboundSignUpdatePacket(this.position, lines);
    }
}

