/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundSetEntityMotionPacket
implements Packet {
    private final int entityId;
    private final double motionX;
    private final double motionY;
    private final double motionZ;

    public ClientboundSetEntityMotionPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.motionX = (double)in.readShort() / 8000.0;
        this.motionY = (double)in.readShort() / 8000.0;
        this.motionZ = (double)in.readShort() / 8000.0;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeShort((int)(this.motionX * 8000.0));
        out.writeShort((int)(this.motionY * 8000.0));
        out.writeShort((int)(this.motionZ * 8000.0));
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityMotionPacket)) {
            return false;
        }
        ClientboundSetEntityMotionPacket other = (ClientboundSetEntityMotionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getMotionX(), other.getMotionX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionY(), other.getMotionY()) != 0) {
            return false;
        }
        return Double.compare(this.getMotionZ(), other.getMotionZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetEntityMotionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $motionX = Double.doubleToLongBits(this.getMotionX());
        result = result * 59 + (int)($motionX >>> 32 ^ $motionX);
        long $motionY = Double.doubleToLongBits(this.getMotionY());
        result = result * 59 + (int)($motionY >>> 32 ^ $motionY);
        long $motionZ = Double.doubleToLongBits(this.getMotionZ());
        result = result * 59 + (int)($motionZ >>> 32 ^ $motionZ);
        return result;
    }

    public String toString() {
        return "ClientboundSetEntityMotionPacket(entityId=" + this.getEntityId() + ", motionX=" + this.getMotionX() + ", motionY=" + this.getMotionY() + ", motionZ=" + this.getMotionZ() + ")";
    }

    public ClientboundSetEntityMotionPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityMotionPacket(entityId, this.motionX, this.motionY, this.motionZ);
    }

    public ClientboundSetEntityMotionPacket withMotionX(double motionX) {
        return this.motionX == motionX ? this : new ClientboundSetEntityMotionPacket(this.entityId, motionX, this.motionY, this.motionZ);
    }

    public ClientboundSetEntityMotionPacket withMotionY(double motionY) {
        return this.motionY == motionY ? this : new ClientboundSetEntityMotionPacket(this.entityId, this.motionX, motionY, this.motionZ);
    }

    public ClientboundSetEntityMotionPacket withMotionZ(double motionZ) {
        return this.motionZ == motionZ ? this : new ClientboundSetEntityMotionPacket(this.entityId, this.motionX, this.motionY, motionZ);
    }

    public ClientboundSetEntityMotionPacket(int entityId, double motionX, double motionY, double motionZ) {
        this.entityId = entityId;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }
}

